/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.store.DataHandler;
import com.alibaba.dts.shade.org.h2.store.LobStorageInterface;
import com.alibaba.dts.shade.org.h2.store.LobStorageRemoteInputStream;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueLobDb;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class LobStorageFrontend
implements LobStorageInterface {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final int TABLE_RESULT = -3;
    private final DataHandler handler;

    public LobStorageFrontend(DataHandler handler) {
        this.handler = handler;
    }

    @Override
    public void removeLob(ValueLobDb lob) {
    }

    @Override
    public InputStream getInputStream(ValueLobDb lob, byte[] hmac, long byteCount) throws IOException {
        if (byteCount < 0L) {
            byteCount = Long.MAX_VALUE;
        }
        return new BufferedInputStream(new LobStorageRemoteInputStream(this.handler, lob, hmac, byteCount));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb old, int tableId, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTable(ValueLobDb lob, int tableIdSessionVariable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllForTable(int tableId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value createBlob(InputStream in, long maxLength) {
        return ValueLobDb.createTempBlob(in, maxLength, this.handler);
    }

    @Override
    public Value createClob(Reader reader, long maxLength) {
        return ValueLobDb.createTempClob(reader, maxLength, this.handler);
    }

    @Override
    public void init() {
    }
}

