/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.MVMap;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.StreamStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.dts.shade.org.h2.store.CountingReaderInputStream;
import com.alibaba.dts.shade.org.h2.store.LimitInputStream;
import com.alibaba.dts.shade.org.h2.store.LobStorageInterface;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueLobDb;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    private boolean init;
    private Object nextLobIdSync = new Object();
    private long nextLobId;
    private MVMap<Long, Object[]> lobMap;
    private MVMap<Object[], Boolean> refMap;
    private MVMap<Long, byte[]> dataMap;
    private StreamStore streamStore;

    public LobStorageMap(Database database) {
        this.database = database;
    }

    @Override
    public void init() {
        Long last;
        if (this.init) {
            return;
        }
        this.init = true;
        MVTableEngine.Store s = this.database.getMvStore();
        MVStore mvStore = s == null ? MVStore.open(null) : s.getStore();
        this.lobMap = mvStore.openMap("lobMap");
        this.refMap = mvStore.openMap("lobRef");
        this.dataMap = mvStore.openMap("lobData");
        this.streamStore = new StreamStore(this.dataMap);
        if (this.database.isReadOnly()) {
            return;
        }
        if (this.dataMap.isEmpty()) {
            return;
        }
        long lastUsedKey = -1L;
        for (Map.Entry<Long, Object[]> e : this.lobMap.entrySet()) {
            long lobId = e.getKey();
            Object[] v = e.getValue();
            byte[] id = (byte[])v[0];
            long max = this.streamStore.getMaxBlockKey(id);
            if (max == -1L || max <= lastUsedKey) continue;
            lastUsedKey = max;
        }
        while ((last = this.dataMap.lastKey()) != null && last > lastUsedKey) {
            this.dataMap.remove(last);
        }
        last = this.dataMap.lastKey();
        if (last != null) {
            this.streamStore.setNextKey(last + 1L);
        }
    }

    @Override
    public Value createBlob(InputStream in, long maxLength) {
        this.init();
        int type = 15;
        if (maxLength < 0L) {
            maxLength = Long.MAX_VALUE;
        }
        int max = (int)Math.min(maxLength, (long)this.database.getMaxLengthInplaceLob());
        try {
            if (max != 0 && max < Integer.MAX_VALUE) {
                BufferedInputStream b = new BufferedInputStream(in, max);
                b.mark(max);
                byte[] small = new byte[max];
                int len = IOUtils.readFully(b, small, max);
                if (len < max) {
                    if (len < small.length) {
                        small = Arrays.copyOf(small, len);
                    }
                    return ValueLobDb.createSmallLob(type, small);
                }
                b.reset();
                in = b;
            }
            if (maxLength != Long.MAX_VALUE) {
                in = new LimitInputStream(in, maxLength);
            }
            return this.createLob(in, type);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    @Override
    public Value createClob(Reader reader, long maxLength) {
        this.init();
        int type = 16;
        if (maxLength < 0L) {
            maxLength = Long.MAX_VALUE;
        }
        int max = (int)Math.min(maxLength, (long)this.database.getMaxLengthInplaceLob());
        try {
            if (max != 0 && max < Integer.MAX_VALUE) {
                BufferedReader b = new BufferedReader(reader, max);
                b.mark(max);
                char[] small = new char[max];
                int len = IOUtils.readFully(b, small, max);
                if (len < max) {
                    if (len < small.length) {
                        small = Arrays.copyOf(small, len);
                    }
                    byte[] utf8 = new String(small, 0, len).getBytes(Constants.UTF8);
                    return ValueLobDb.createSmallLob(type, utf8);
                }
                b.reset();
                reader = b;
            }
            CountingReaderInputStream in = new CountingReaderInputStream(reader, maxLength);
            ValueLobDb lob = this.createLob(in, type);
            lob = ValueLobDb.create(type, this.database, lob.getTableId(), lob.getLobId(), null, in.getLength());
            return lob;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private ValueLobDb createLob(InputStream in, int type) throws IOException {
        byte[] streamStoreId;
        try {
            streamStoreId = this.streamStore.put(in);
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        long lobId = this.generateLobId();
        long length = this.streamStore.length(streamStoreId);
        int tableId = -2;
        Object[] value = new Object[]{streamStoreId, tableId, length, 0};
        this.lobMap.put(lobId, value);
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.put(key, Boolean.TRUE);
        ValueLobDb lob = ValueLobDb.create(type, this.database, tableId, lobId, null, length);
        return lob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateLobId() {
        Object object = this.nextLobIdSync;
        synchronized (object) {
            if (this.nextLobId == 0L) {
                Long id = this.lobMap.lastKey();
                this.nextLobId = id == null ? 1L : id + 1L;
            }
            return this.nextLobId++;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb old, int tableId, long length) {
        this.init();
        int type = old.getType();
        long oldLobId = old.getLobId();
        long oldLength = old.getPrecision();
        if (oldLength != length) {
            throw DbException.throwInternalError("Length is different");
        }
        Object[] value = this.lobMap.get(oldLobId);
        value = (Object[])value.clone();
        byte[] streamStoreId = (byte[])value[0];
        long lobId = this.generateLobId();
        value[1] = tableId;
        this.lobMap.put(lobId, value);
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.put(key, Boolean.TRUE);
        ValueLobDb lob = ValueLobDb.create(type, this.database, tableId, lobId, null, length);
        return lob;
    }

    @Override
    public InputStream getInputStream(ValueLobDb lob, byte[] hmac, long byteCount) throws IOException {
        this.init();
        Object[] value = this.lobMap.get(lob.getLobId());
        if (value == null) {
            if (lob.getTableId() == -3 || lob.getTableId() == -1) {
                throw DbException.get(90039, "" + lob.getLobId() + "/" + lob.getTableId());
            }
            throw DbException.throwInternalError("Lob not found: " + lob.getLobId() + "/" + lob.getTableId());
        }
        byte[] streamStoreId = (byte[])value[0];
        return this.streamStore.get(streamStoreId);
    }

    @Override
    public void setTable(ValueLobDb lob, int tableId) {
        this.init();
        long lobId = lob.getLobId();
        Object[] value = this.lobMap.remove(lobId);
        value[1] = tableId;
        this.lobMap.put(lobId, value);
    }

    @Override
    public void removeAllForTable(int tableId) {
        this.init();
        if (this.database.getMvStore().getStore().isClosed()) {
            return;
        }
        ArrayList list = New.arrayList();
        for (Map.Entry<Long, Object[]> e : this.lobMap.entrySet()) {
            Object[] value = e.getValue();
            int t = (Integer)value[1];
            if (t != tableId) continue;
            list.add(e.getKey());
        }
        Iterator<Map.Entry<Long, Object>> i$ = list.iterator();
        while (i$.hasNext()) {
            long lobId = (Long)((Object)i$.next());
            this.removeLob(tableId, lobId);
        }
        if (tableId == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    @Override
    public void removeLob(ValueLobDb lob) {
        this.init();
        int tableId = lob.getTableId();
        long lobId = lob.getLobId();
        this.removeLob(tableId, lobId);
    }

    private void removeLob(int tableId, long lobId) {
        byte[] s2;
        Object[] value = this.lobMap.remove(lobId);
        if (value == null) {
            return;
        }
        byte[] streamStoreId = (byte[])value[0];
        Object[] key = new Object[]{streamStoreId, lobId};
        this.refMap.remove(key);
        key = new Object[]{streamStoreId, 0L};
        value = this.refMap.ceilingKey(key);
        boolean hasMoreEntries = false;
        if (value != null && Arrays.equals(streamStoreId, s2 = (byte[])value[0])) {
            hasMoreEntries = true;
        }
        if (!hasMoreEntries) {
            this.streamStore.remove(streamStoreId);
        }
    }

    private static void trace(String op) {
        System.out.println("[" + Thread.currentThread().getName() + "] LOB " + op);
    }
}

