/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.remoting.proxy;

import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.tmq.common.remoting.protocol.RemotingCommand;
import com.alibaba.tmq.common.util.BytesUtil;
import com.alibaba.tmq.common.util.RemotingUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientInvocationHandler
extends ClientContext
implements InvocationHandler,
Constants {
    private static final Log logger = LogFactory.getLog(ClientInvocationHandler.class);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ConnectionChannel connectionChannel = InvocationContext.acquireConnectionChannel();
        connectionChannel.setLocalId(clientConfig.getClientId());
        connectionChannel.setLocalVersion(clientConfig.getVersion());
        Channel channel = clientRemoting.getAndCreateChannel(connectionChannel.getRemoteAddress());
        if (null == channel) {
            if (method.getName().equals("connect")) {
                logger.warn((Object)("[ClientInvocationHandler]: getAndCreateChannel error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            } else {
                logger.error((Object)("[ClientInvocationHandler]: getAndCreateChannel error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            }
            InvocationContext.clean();
            return null;
        }
        connectionChannel.setLocalAddress(RemotingUtil.socketAddress2String(channel.localAddress()));
        InvokeMethod invokeMethod = new InvokeMethod(connectionChannel, method.getName(), method.getParameterTypes(), args);
        byte[] requestBody = null;
        try {
            requestBody = BytesUtil.objectToBytes(invokeMethod);
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientInvocationHandler]: objectToBytes error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()), e);
            InvocationContext.clean();
            return null;
        }
        if (null == requestBody) {
            logger.error((Object)("[ClientInvocationHandler]: requestBody is null, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            InvocationContext.clean();
            return null;
        }
        RemotingCommand request = new RemotingCommand();
        request.setBody(requestBody);
        RemotingCommand response = null;
        try {
            response = clientRemoting.invokeSync(connectionChannel.getRemoteAddress(), request, connectionChannel.getTimeout());
        }
        catch (Throwable e) {
            if (method.getName().equals("connect")) {
                logger.warn((Object)("[ClientInvocationHandler]: invoke error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()), e);
            }
            logger.error((Object)("[ClientInvocationHandler]: invoke error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()), e);
        }
        InvocationContext.clean();
        if (null == response) {
            if (method.getName().equals("connect")) {
                logger.warn((Object)("[ClientInvocationHandler]: response is null, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            } else {
                logger.error((Object)("[ClientInvocationHandler]: response is null, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            }
            return null;
        }
        if (Void.TYPE == method.getGenericReturnType()) {
            return null;
        }
        byte[] responseBody = response.getBody();
        if (null == responseBody) {
            logger.error((Object)("[ClientInvocationHandler]: responseBody is null, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            return null;
        }
        Object object = null;
        try {
            object = BytesUtil.bytesToObject(responseBody);
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientInvocationHandler]: bytesToObject error, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()), e);
        }
        if (null == object) {
            logger.error((Object)("[ClientInvocationHandler]: object is null, server:" + connectionChannel.getRemoteAddress() + ", timeout:" + connectionChannel.getTimeout() + ", methodName:" + method.getName()));
            return null;
        }
        return object;
    }
}

