/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.ClusterEnum;
import java.util.Date;

public class Cluster
implements Constants {
    private long id;
    private Date gmtCreate;
    private Date gmtModified;
    private String description;
    private int clusterId;

    public static Cluster newInstance(String json) {
        String[] field = json.split(":");
        Cluster cluster = new Cluster();
        cluster.setId(Long.parseLong(field[0]));
        cluster.setGmtCreate(new Date(Long.parseLong(field[1])));
        cluster.setGmtModified(new Date(Long.parseLong(field[2])));
        cluster.setDescription(new String(Cluster.getBytes(field[3]), DEFAULT_CHARSET));
        cluster.setClusterId(Integer.parseInt(field[4]));
        return cluster;
    }

    public String toString() {
        byte[] bytes = null;
        try {
            bytes = this.description.getBytes(DEFAULT_CHARSET);
        }
        catch (Throwable e) {
            throw new RuntimeException("[Cluster]: toString error, description:" + this.description, e);
        }
        return this.id + ":" + this.gmtCreate.getTime() + ":" + this.gmtModified.getTime() + ":" + Cluster.getString(bytes) + ":" + this.clusterId;
    }

    public static String getString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(bytes[i] + "%2C");
        }
        return sb.toString();
    }

    public static byte[] getBytes(String string) {
        String[] charArray = string.split("%2C");
        byte[] bytes = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            bytes[i] = Byte.parseByte(charArray[i]);
        }
        return bytes;
    }

    public static boolean isValid(int clusterId) {
        if (ClusterEnum.DAILY.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.SECOND.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.TEST.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.DAILY_UNIT.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.PRE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.ONLINE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.B2B_PRE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.B2B_ONLINE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.PRE_USA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.ONLINE_USA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.PRE_USA_TWO.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.ONLINE_USA_TWO.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.PRE_DD.getClusterId() == clusterId) {
            return true;
        }
        return ClusterEnum.ONLINE_DD.getClusterId() == clusterId;
    }

    public static boolean isOnline(int clusterId) {
        if (ClusterEnum.ONLINE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.B2B_ONLINE_CHINA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.ONLINE_USA.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.ONLINE_USA_TWO.getClusterId() == clusterId) {
            return true;
        }
        if (ClusterEnum.PRE_DD.getClusterId() == clusterId) {
            return true;
        }
        return ClusterEnum.ONLINE_DD.getClusterId() == clusterId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int clusterId) {
        this.clusterId = clusterId;
    }
}

