/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.monitor;

import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.remoting.Pair;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.monitor.callback.Display;
import com.alibaba.tmq.common.monitor.timer.MethodCountTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;

public class MethodMonitor {
    private final Log logger;
    private final ConcurrentHashMap<String, Pair<AtomicLong, AtomicLong>> methodCountTable = new ConcurrentHashMap();
    private final ConcurrentSkipListMap<String, ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>>> monitorTable = new ConcurrentSkipListMap();
    private final List<Display> displayList = new ArrayList<Display>();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "TMQ-MethodMonitor-Thread-" + this.index);
        }
    });

    public MethodMonitor(Log logger) {
        this.logger = logger;
    }

    public void init() throws InitException {
    }

    public void initMethodCountTimer() throws InitException {
        try {
            this.executorService.scheduleAtFixedRate(new MethodCountTimer(this.logger, this.displayList, this.methodCountTable), 0L, 1000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[MethodMonitor]: initMethodCountTimer error", e);
        }
    }

    public void addDisplay(Display display) {
        this.displayList.add(display);
    }

    public void methodCount(String key, long startTime) {
        try {
            Pair<AtomicLong, AtomicLong> countPair = this.getCountPair(key);
            AtomicLong counter = countPair.getObject1();
            counter.incrementAndGet();
            AtomicLong totalTime = countPair.getObject2();
            totalTime.addAndGet(System.currentTimeMillis() - startTime);
        }
        catch (Throwable e) {
            this.logger.error((Object)("[MethodMonitor]: methodCount error, key:" + key + ", startTime:" + startTime));
        }
    }

    public void methodCount(String roleKey, String methodKey, long startTime) {
        try {
            ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> counterTable = this.getCounterTable(roleKey);
            KeyValuePair<AtomicLong, AtomicLong> counterPair = this.getCounterPair(counterTable, methodKey);
            AtomicLong counter = counterPair.getKey();
            counter.incrementAndGet();
            AtomicLong totalTime = counterPair.getValue();
            totalTime.addAndGet(System.currentTimeMillis() - startTime);
        }
        catch (Throwable e) {
            this.logger.error((Object)("[MethodMonitor]: methodCount error, roleKey:" + roleKey + ", methodKey:" + methodKey + ", startTime:" + startTime));
        }
    }

    private ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> getCounterTable(String roleKey) {
        ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> existCounterTable;
        ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> counterTable = this.monitorTable.get(roleKey);
        if (null == counterTable && (existCounterTable = this.monitorTable.putIfAbsent(roleKey, counterTable = new ConcurrentSkipListMap())) != null) {
            counterTable = existCounterTable;
        }
        return counterTable;
    }

    private KeyValuePair<AtomicLong, AtomicLong> getCounterPair(ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> counterTable, String methodKey) {
        KeyValuePair<AtomicLong, AtomicLong> existCounterPair;
        KeyValuePair<AtomicLong, AtomicLong> counterPair = counterTable.get(methodKey);
        if (null == counterPair && (existCounterPair = counterTable.putIfAbsent(methodKey, counterPair = new KeyValuePair<AtomicLong, AtomicLong>(new AtomicLong(0L), new AtomicLong(0L)))) != null) {
            counterPair = existCounterPair;
        }
        return counterPair;
    }

    private Pair<AtomicLong, AtomicLong> getCountPair(String key) {
        Pair<AtomicLong, AtomicLong> existCountPair;
        Pair<AtomicLong, AtomicLong> countPair = this.methodCountTable.get(key);
        if (null == countPair && (existCountPair = this.methodCountTable.putIfAbsent(key, countPair = new Pair<AtomicLong, AtomicLong>(new AtomicLong(0L), new AtomicLong(0L)))) != null) {
            countPair = existCountPair;
        }
        return countPair;
    }

    public List<Display> getDisplayList() {
        return this.displayList;
    }

    public ConcurrentSkipListMap<String, ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>>> getMonitorTable() {
        return this.monitorTable;
    }
}

