/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.dts.shade.com.taobao.diamond.manager.DiamondManager;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.dts.shade.com.taobao.diamond.manager.impl.DefaultDiamondManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiamondHelper {
    private static final Log logger = LogFactory.getLog(DiamondHelper.class);
    private static final Map<String, DiamondContext> contexts = new HashMap<String, DiamondContext>();
    private static final Executor executor = Executors.newSingleThreadScheduledExecutor();
    private static final ReentrantLock lock = new ReentrantLock();
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private static final long DEFAULT_READ_TIMOUT = 3000L;

    public static String getData(String dataId) {
        return DiamondHelper.getData(dataId, 3000L);
    }

    public static String getData(String dataId, long timeOut) {
        DiamondContext context = DiamondHelper.getContext(dataId);
        return context.getManager().getAvailableConfigureInfomation(timeOut);
    }

    public static DiamondManager getDiamondManager(String dataId) {
        DiamondContext context = DiamondHelper.getContext(dataId);
        return context.getManager();
    }

    public static void addListener(String dataId, DataListener dataListener) {
        if (null != dataListener) {
            DiamondContext context = DiamondHelper.getContext(dataId);
            context.getListener().addListener(dataListener);
        }
    }

    public static void removeListener(String dataId, DataListener dataListener) {
        if (null != dataListener) {
            DiamondContext context = DiamondHelper.getContext(dataId);
            context.getListener().removeListener(dataListener);
        }
    }

    public static void cleanListener(String dataId) {
        DiamondContext context = DiamondHelper.getContext(dataId);
        context.getListener().cleanListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanListener() {
        lock.lock();
        try {
            for (Map.Entry<String, DiamondContext> entry : contexts.entrySet()) {
                DiamondContext diamondContext = entry.getValue();
                diamondContext.getListener().cleanListener();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DiamondContext buildContext(String dataId) {
        DiamondContext context = contexts.get(dataId);
        if (null == context) {
            lock.lock();
            try {
                context = contexts.get(dataId);
                if (null == context) {
                    ControlListener controlListener = new ControlListener(dataId);
                    DefaultDiamondManager diamondManager = new DefaultDiamondManager(DEFAULT_GROUP, dataId, controlListener);
                    context = new DiamondContext(diamondManager, controlListener);
                    contexts.put(dataId, context);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return context;
    }

    private static DiamondContext getContext(String dataId) {
        DiamondContext context = contexts.get(dataId);
        if (null == context) {
            context = DiamondHelper.buildContext(dataId);
        }
        return context;
    }

    public static void main(String[] args) {
        String dataId = "qihao.qihao.qihao";
        String data = DiamondHelper.getData(dataId);
        System.out.println(data);
        DiamondHelper.addListener(dataId, new DataListener(){

            @Override
            public void receiveConfigInfo(String dataId, String configInfo) {
                System.out.println(dataId + " " + configInfo + " " + this.toString());
            }
        });
        DiamondHelper.addListener(dataId, new DataListener(){

            @Override
            public void receiveConfigInfo(String dataId, String configInfo) {
                System.out.println(dataId + " " + configInfo + " " + this.toString());
            }
        });
    }

    public static interface DataListener {
        public void receiveConfigInfo(String var1, String var2);
    }

    static class ControlListener
    implements ManagerListener {
        private final String dataId;
        private CopyOnWriteArrayList<DataListener> dataListeners = new CopyOnWriteArrayList();

        public ControlListener(String dataId) {
            this.dataId = dataId;
        }

        public void addListener(DataListener listener) {
            this.dataListeners.addIfAbsent(listener);
        }

        public void removeListener(DataListener listener) {
            this.dataListeners.remove(listener);
        }

        public void cleanListener() {
            this.dataListeners.clear();
        }

        @Override
        public void receiveConfigInfo(String configInfo) {
            for (DataListener listener : this.dataListeners) {
                try {
                    listener.receiveConfigInfo(this.dataId, configInfo);
                }
                catch (Exception e) {
                    logger.error((Object)("call dataListener Error dataId: " + this.dataId), (Throwable)e);
                }
            }
        }

        @Override
        public Executor getExecutor() {
            return executor;
        }
    }

    static class DiamondContext {
        private final ControlListener listener;
        private final DiamondManager manager;

        public DiamondContext(DiamondManager manager, ControlListener listener) {
            this.listener = listener;
            this.manager = manager;
        }

        public ControlListener getListener() {
            return this.listener;
        }

        public DiamondManager getManager() {
            return this.manager;
        }
    }
}

