/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.dts.shade.com.taobao.diamond.client.Diamond;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListenerAdapter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiamondUtil {
    private static final Log logger = LogFactory.getLog(DiamondUtil.class);
    public static Properties properties = new Properties();
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";

    public static void addListener(final String key) {
        try {
            String value = Diamond.getConfig(key, DEFAULT_GROUP, 400L);
            properties.setProperty(key, value);
            logger.info((Object)("init key: " + key + " val: " + value));
            Diamond.addListener(key, DEFAULT_GROUP, new ManagerListenerAdapter(){

                @Override
                public void receiveConfigInfo(String configInfo) {
                    logger.warn((Object)("diamond config update, dataId=" + key + ", newValue=" + configInfo));
                    properties.setProperty(key, configInfo);
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)"[DiamondUtil]addListener error", (Throwable)e);
        }
    }

    public static boolean getBooleanVal(String key) {
        boolean result = false;
        try {
            result = Boolean.parseBoolean(properties.getProperty(key, "false"));
        }
        catch (Exception e) {
            logger.error((Object)("[DiamondUtil]getBooleanVal error, key: " + key), (Throwable)e);
        }
        return result;
    }

    public static String getStringVal(String key) {
        String result = null;
        try {
            result = properties.getProperty(key);
        }
        catch (Exception e) {
            logger.error((Object)("[DiamondUtil]getBooleanVal error, key: " + key), (Throwable)e);
        }
        return result;
    }
}

