/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLogger;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.TracePoint;
import com.alibaba.tmq.common.logger.LoggerEvent;
import com.alibaba.tmq.common.util.TimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LoggerUtil
implements Constants {
    private static final TraceLogger traceLogger = EagleEye.traceLogger("TMQ_MessageTraceLogger");
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(LoggerUtil.class);
    private static final LinkedBlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue();
    private static final ThreadPoolExecutor executors = new ThreadPoolExecutor(16, 16, 10000L, TimeUnit.MILLISECONDS, eventQueue, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "TMQ-LoggerEvent-thread-" + this.index);
        }
    });
    private static LoggerEvent loggerEvent;

    public static void setLoggerEvent(LoggerEvent loggerEvent) {
        LoggerUtil.loggerEvent = loggerEvent;
    }

    public static void info(final Message message, final String action, final long startTime, final String localAddress) {
        final long cost = System.currentTimeMillis() - startTime;
        final String logContent = TimeUtil.date2MilliSeconds(new Date()) + ", action:" + action + ", time:" + cost + ", localAddress:" + localAddress + ", message:" + message;
        if (loggerEvent != null) {
            executors.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList<TracePoint> tracePointList = new ArrayList<TracePoint>();
                        tracePointList.add(LoggerUtil.tracePoint(message, action, startTime, cost, localAddress));
                        loggerEvent.onEvent(tracePointList);
                    }
                    catch (Throwable e) {
                        logger.error("[LoggerUtil]: onEvent error, logContent:" + logContent, e);
                    }
                }
            });
        }
        traceLogger.logLine("TMQ_Logger_key", StringUtil.isBlank(message.getMessageId()) ? message.getMessageKey() : message.getMessageId(), logContent);
    }

    public static void info(final List<? extends Message> messageList, final String action, final long startTime, final String localAddress) {
        final long cost = System.currentTimeMillis() - startTime;
        final String logContent = TimeUtil.date2MilliSeconds(new Date()) + ", action:" + action + ", time:" + cost + ", localAddress:" + localAddress + ", messageList:" + messageList;
        if (loggerEvent != null) {
            executors.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList<TracePoint> tracePointList = new ArrayList<TracePoint>();
                        for (Message message : messageList) {
                            tracePointList.add(LoggerUtil.tracePoint(message, action, startTime, cost, localAddress));
                        }
                        loggerEvent.onEvent(tracePointList);
                    }
                    catch (Throwable e) {
                        logger.error("[LoggerUtil]: onEvent error, logContent:" + logContent, e);
                    }
                }
            });
        }
        traceLogger.logLine("TMQ_Logger_key", messageList.get(0).getMessageKey(), logContent);
    }

    public static TracePoint tracePoint(Message message, String action, long startTime, long cost, String localAddress) {
        TracePoint tracePoint = new TracePoint();
        tracePoint.setGmtCreate(new Date());
        tracePoint.setGmtModified(new Date());
        tracePoint.setMessageId(message.getMessageId());
        tracePoint.setMessageKey(message.getMessageKey());
        tracePoint.setAction(action);
        tracePoint.setTimestamp(startTime);
        tracePoint.setCost(cost);
        tracePoint.setLocalAddress(localAddress);
        tracePoint.setMessage(message.toString());
        tracePoint.setClusterId(message.getClusterId());
        return tracePoint;
    }

    public static String displayTable(ConcurrentHashMap<String, String> relationTable, ConcurrentSkipListMap<String, ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>>> monitorTable) {
        String key = "Role";
        ArrayList<String> header = new ArrayList<String>();
        header.add("Topic - UniqueTable");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        for (Map.Entry<String, ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>>> entry : monitorTable.entrySet()) {
            String roleId = entry.getKey();
            ConcurrentSkipListMap<String, KeyValuePair<AtomicLong, AtomicLong>> methodTable = entry.getValue();
            ArrayList<String> itemList = new ArrayList<String>();
            String tu = relationTable.get(roleId);
            if (tu != null) {
                itemList.add(tu);
            } else {
                itemList.add("");
            }
            for (Map.Entry<String, KeyValuePair<AtomicLong, AtomicLong>> methodEntry : methodTable.entrySet()) {
                String method = methodEntry.getKey();
                KeyValuePair<AtomicLong, AtomicLong> pair = methodEntry.getValue();
                if (!header.contains(method)) {
                    header.add(method);
                }
                AtomicLong counter = pair.getKey();
                AtomicLong totalTime = pair.getValue();
                int index = header.indexOf(method);
                int size = itemList.size();
                if (index >= itemList.size()) {
                    for (int i = 0; i < index - size; ++i) {
                        itemList.add("");
                    }
                    itemList.add(counter.get() + " , " + (0L == counter.get() ? 0L : totalTime.get() / counter.get()));
                } else {
                    itemList.set(index, counter.get() + " , " + (0L == counter.get() ? 0L : totalTime.get() / counter.get()));
                }
                counter.set(0L);
                totalTime.set(0L);
            }
            body.put(roleId, itemList);
        }
        return LoggerUtil.displayTable(key, header, body);
    }

    public static String displayTable(String key, List<String> header, Map<String, List<String>> body) {
        StringBuilder table = new StringBuilder();
        List<AtomicInteger> maxLengthList = LoggerUtil.getMaxLengthList(key, header, body);
        ArrayList<String> head = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            head.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", head, maxLengthList));
        table.append(LoggerUtil.displayLine(true, key, header, maxLengthList));
        ArrayList<String> interlaced = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            interlaced.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", interlaced, maxLengthList));
        for (Map.Entry<String, List<String>> entry : body.entrySet()) {
            String topic = entry.getKey();
            List<String> itemList = entry.getValue();
            table.append(LoggerUtil.displayLine(true, topic, itemList, maxLengthList));
        }
        ArrayList<String> tail = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            tail.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", tail, maxLengthList));
        return table.toString();
    }

    private static String displayLine(boolean isLine, String key, List<String> itemList, List<AtomicInteger> maxLengthList) {
        StringBuilder line = new StringBuilder();
        line.append((isLine ? " | " : " + ") + key + LoggerUtil.displayBlank(isLine, maxLengthList.get(0), key));
        for (int i = 0; i < maxLengthList.size() - 1; ++i) {
            if (i >= itemList.size()) {
                line.append((isLine ? " | " : " + ") + "" + LoggerUtil.displayBlank(isLine, maxLengthList.get(i + 1), ""));
                continue;
            }
            line.append((isLine ? " | " : " + ") + itemList.get(i) + LoggerUtil.displayBlank(isLine, maxLengthList.get(i + 1), itemList.get(i)));
        }
        line.append((isLine ? " | " : " + ") + "\n");
        return line.toString();
    }

    private static String displayBlank(boolean isLine, AtomicInteger length, String item) {
        StringBuilder blank = new StringBuilder(isLine ? " " : "-");
        for (int i = 0; i < length.get() - item.length(); ++i) {
            blank.append(isLine ? " " : "-");
        }
        return blank.toString();
    }

    private static List<AtomicInteger> getMaxLengthList(String key, List<String> header, Map<String, List<String>> body) {
        ArrayList<AtomicInteger> maxLengthList = new ArrayList<AtomicInteger>();
        for (int i = 0; i < 1 + header.size(); ++i) {
            maxLengthList.add(new AtomicInteger(0));
        }
        LoggerUtil.refreshMaxLengthList(maxLengthList, key, header);
        for (Map.Entry<String, List<String>> entry : body.entrySet()) {
            String topic = entry.getKey();
            List<String> itemList = entry.getValue();
            LoggerUtil.refreshMaxLengthList(maxLengthList, topic, itemList);
        }
        return maxLengthList;
    }

    private static void refreshMaxLengthList(List<AtomicInteger> maxLengthList, String key, List<String> itemList) {
        for (int i = 0; i < maxLengthList.size(); ++i) {
            AtomicInteger length = maxLengthList.get(i);
            if (i > itemList.size() || length.intValue() >= (0 == i ? key.length() : itemList.get(i - 1).length())) continue;
            length.set(0 == i ? key.length() : itemList.get(i - 1).length());
        }
    }
}

