/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.util.ListUtil;
import java.util.ArrayList;
import java.util.List;

public class TableUtil
implements Constants {
    public static List<KeyValuePair<String, String>> initTableList(String group) {
        ArrayList<KeyValuePair<String, String>> tablePairList = new ArrayList<KeyValuePair<String, String>>();
        for (int i = 0; i < 2048; ++i) {
            tablePairList.add(new KeyValuePair<String, String>(TableUtil.createDbGroup(group, i), TableUtil.createTable(i)));
        }
        return tablePairList;
    }

    public static List<KeyValuePair<String, String>> initTableList(String group, int serverAmount, int serverNumber) {
        ArrayList<KeyValuePair<String, String>> tablePairList = new ArrayList<KeyValuePair<String, String>>();
        for (int i = 0; i < 2048; ++i) {
            if (serverNumber != i % serverAmount) continue;
            String dbGroup = TableUtil.createDbGroup(group, i);
            String table = TableUtil.createTable(i);
            tablePairList.add(new KeyValuePair<String, String>(dbGroup, table));
        }
        return tablePairList;
    }

    public static String acquireFireServer(List<String> serverList, String messageKey) {
        if (ListUtil.isEmpty(serverList)) {
            return null;
        }
        int table = Math.abs(messageKey.hashCode()) % 2048;
        int index = table % serverList.size();
        return serverList.get(index);
    }

    public static String createDbGroup(String group, int index) {
        return group + decimalFormat.format(index / 64) + "_GROUP";
    }

    public static String createTable(int index) {
        return "tmq_message_" + decimalFormat.format(index);
    }
}

