/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class ConfigTransportClient {
    private static final String CONFIG_INFO_HEADER = "exConfigInfo";
    private static final String DEFAULT_CONFIG_INFO = "true";
    String encode;
    String tenant;
    ScheduledExecutorService executor;
    final ServerListManager serverListManager;
    final Properties properties;
    private int maxRetry = 3;
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    protected SecurityProxy securityProxy;

    public void shutdown() throws NacosException {
        this.securityProxy.shutdown();
    }

    public ConfigTransportClient(NacosClientProperties properties, ServerListManager serverListManager) {
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank(encodeTmp) ? "UTF-8" : encodeTmp.trim();
        this.tenant = properties.getProperty("namespace");
        this.serverListManager = serverListManager;
        this.properties = properties.asProperties();
        this.securityProxy = new SecurityProxy(serverListManager.getServerUrls(), ConfigHttpClientManager.getInstance().getNacosRestTemplate());
    }

    protected RequestResource buildResource(String tenant, String group, String dataId) {
        return RequestResource.configBuilder().setNamespace(tenant).setGroup(group).setResource(dataId).build();
    }

    protected Map<String, String> getSecurityHeaders(RequestResource resource) throws Exception {
        return this.securityProxy.getIdentityContext(resource);
    }

    protected Map<String, String> getCommonHeader() {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5Utils.md5Hex(ts + ParamUtil.getAppKey(), "UTF-8");
        headers.put("Client-AppName", ParamUtil.getAppName());
        headers.put("Client-RequestTS", ts);
        headers.put("Client-RequestToken", token);
        headers.put(CONFIG_INFO_HEADER, DEFAULT_CONFIG_INFO);
        headers.put("charset", this.encode);
        return headers;
    }

    private void initMaxRetry(Properties properties) {
        this.maxRetry = ConvertUtils.toInt(String.valueOf(properties.get("maxRetry")), 3);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void start() throws NacosException {
        this.securityProxy.login(this.properties);
        this.executor.scheduleWithFixedDelay(() -> this.securityProxy.login(this.properties), 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
        this.startInternal();
    }

    public abstract void startInternal() throws NacosException;

    public abstract String getName();

    public String getEncode() {
        return this.encode;
    }

    public String getTenant() {
        return this.tenant;
    }

    public abstract void notifyListenConfig();

    public abstract void executeConfigListen();

    public abstract void removeCache(String var1, String var2);

    public abstract ConfigResponse queryConfig(String var1, String var2, String var3, long var4, boolean var6) throws NacosException;

    public abstract boolean publishConfig(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10) throws NacosException;

    public abstract boolean removeConfig(String var1, String var2, String var3, String var4) throws NacosException;
}

