/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.utils.StringUtils;
import java.net.URI;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;

public enum BaseHttpMethod {
    GET("GET"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpGet(url);
        }
    }
    ,
    GET_LARGE("GET-LARGE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpGetWithEntity(url);
        }
    }
    ,
    POST("POST"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPost(url);
        }
    }
    ,
    PUT("PUT"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPut(url);
        }
    }
    ,
    DELETE("DELETE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpDelete(url);
        }
    }
    ,
    DELETE_LARGE("DELETE_LARGE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpDeleteWithEntity(url);
        }
    }
    ,
    HEAD("HEAD"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpHead(url);
        }
    }
    ,
    TRACE("TRACE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    }
    ,
    PATCH("PATCH"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPatch(url);
        }
    }
    ,
    OPTIONS("OPTIONS"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    };

    private String name;

    private BaseHttpMethod(String name) {
        this.name = name;
    }

    public HttpRequestBase init(String url) {
        return this.createRequest(url);
    }

    protected HttpRequestBase createRequest(String url) {
        throw new UnsupportedOperationException();
    }

    public static BaseHttpMethod sourceOf(String name) {
        for (BaseHttpMethod method : BaseHttpMethod.values()) {
            if (!StringUtils.equalsIgnoreCase(name, method.name)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unsupported http method : " + name);
    }

    public static class HttpDeleteWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public HttpDeleteWithEntity(String url) {
            this.setURI(URI.create(url));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "GET";

        public HttpGetWithEntity(String url) {
            this.setURI(URI.create(url));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

