/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redisson;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redisson.RedissonCacheConfig;
import com.alicp.jetcache.support.CacheEncodeException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;

public class RedissonCache<K, V>
extends AbstractExternalCache<K, V> {
    private final RedissonClient client;
    private final RedissonCacheConfig<K, V> config;
    private final Function<Object, byte[]> valueEncoder;
    private final Function<byte[], Object> valueDecoder;

    public RedissonCache(RedissonCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.client = config.getRedissonClient();
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
    }

    protected String getCacheKey(K key) {
        byte[] newKey = this.buildKey(key);
        return new String(newKey, StandardCharsets.UTF_8);
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("RedissonCache does not support unwrap");
    }

    private Codec getCodec() {
        return ByteArrayCodec.INSTANCE;
    }

    private byte[] encoder(CacheValueHolder<V> holder) {
        if (Objects.nonNull(holder)) {
            return this.valueEncoder.apply(holder);
        }
        return null;
    }

    private CacheValueHolder<V> decoder(K key, byte[] data, int counter) {
        CacheValueHolder<V> holder = null;
        if (Objects.nonNull(data) && data.length > 0) {
            try {
                holder = (CacheValueHolder<V>)this.valueDecoder.apply(data);
            }
            catch (CacheEncodeException e) {
                holder = this.compatibleOldVal(key, data, counter + 1);
                if (Objects.isNull(holder)) {
                    this.logError("decoder", key, e);
                }
            }
            catch (Throwable e) {
                this.logError("decoder", key, e);
            }
        }
        return holder;
    }

    private CacheValueHolder<V> decoder(K key, byte[] data) {
        return this.decoder(key, data, 0);
    }

    private CacheValueHolder<V> compatibleOldVal(K key, byte[] data, int counter) {
        if (Objects.nonNull(key) && Objects.nonNull(data) && data.length > 0 && counter <= 1) {
            try {
                Codec codec = this.client.getConfig().getCodec();
                if (Objects.nonNull(codec)) {
                    Class<ByteArrayCodec> cls = ByteArrayCodec.class;
                    if (codec.getClass() != cls) {
                        ByteBuf in = ByteBufAllocator.DEFAULT.buffer().writeBytes(data);
                        byte[] out = (byte[])codec.getValueDecoder().decode(in, null);
                        return this.decoder(key, out, counter);
                    }
                }
            }
            catch (Throwable e) {
                this.logError("compatibleOldVal", key, e);
            }
        }
        return null;
    }

    protected CacheGetResult<V> do_GET(K key) {
        try {
            RBucket rb = this.client.getBucket(this.getCacheKey(key), this.getCodec());
            CacheValueHolder<V> holder = this.decoder(key, (byte[])rb.get());
            if (Objects.nonNull(holder)) {
                long now = System.currentTimeMillis();
                long expire = holder.getExpireTime();
                if (expire > 0L && now >= expire) {
                    return CacheGetResult.EXPIRED_WITHOUT_MSG;
                }
                return new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
            }
            return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("GET", key, e);
            return new CacheGetResult(e);
        }
    }

    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        try {
            HashMap<K, CacheGetResult> retMap = new HashMap<K, CacheGetResult>(16);
            if (Objects.nonNull(keys) && !keys.isEmpty()) {
                HashMap keyMap = new HashMap(keys.size());
                keys.stream().filter(Objects::nonNull).forEach(k -> {
                    String key = this.getCacheKey(k);
                    if (Objects.nonNull(key)) {
                        keyMap.put(k, key);
                    }
                });
                if (!keyMap.isEmpty()) {
                    Map kvMap = this.client.getBuckets(this.getCodec()).get(keyMap.values().toArray(new String[0]));
                    long now = System.currentTimeMillis();
                    for (K k2 : keys) {
                        CacheValueHolder<V> holder;
                        String key = (String)keyMap.get(k2);
                        if (Objects.nonNull(key) && Objects.nonNull(kvMap) && Objects.nonNull(holder = this.decoder(k2, (byte[])kvMap.get(key)))) {
                            long expire = holder.getExpireTime();
                            CacheGetResult ret = expire > 0L && now >= expire ? CacheGetResult.EXPIRED_WITHOUT_MSG : new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                            retMap.put(k2, ret);
                            continue;
                        }
                        retMap.put(k2, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                    }
                }
            }
            return new MultiGetResult(CacheResultCode.SUCCESS, null, retMap);
        }
        catch (Throwable e) {
            this.logError("GET_ALL", "keys(" + (Objects.nonNull(keys) ? keys.size() : 0) + ")", e);
            return new MultiGetResult(e);
        }
    }

    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            this.client.getBucket(this.getCacheKey(key), this.getCodec()).set((Object)this.encoder(holder), expireAfterWrite, timeUnit);
            return CacheGetResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT", key, e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            if (Objects.nonNull(map) && !map.isEmpty()) {
                long expire = timeUnit.toMillis(expireAfterWrite);
                RBatch batch = this.client.createBatch();
                map.forEach((k, v) -> {
                    CacheValueHolder holder = new CacheValueHolder(v, expire);
                    batch.getBucket(this.getCacheKey(k), this.getCodec()).setAsync((Object)this.encoder(holder), expireAfterWrite, timeUnit);
                });
                batch.execute();
            }
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_REMOVE(K key) {
        try {
            boolean ret = this.client.getBucket(this.getCacheKey(key), this.getCodec()).delete();
            return ret ? CacheResult.SUCCESS_WITHOUT_MSG : CacheResult.FAIL_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("REMOVE", key, e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        try {
            if (Objects.nonNull(keys) && !keys.isEmpty()) {
                RBatch batch = this.client.createBatch();
                keys.forEach(key -> batch.getBucket(this.getCacheKey(key), this.getCodec()).deleteAsync());
                batch.execute();
            }
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            Duration expire = Duration.ofMillis(timeUnit.toMillis(expireAfterWrite));
            CacheValueHolder holder = new CacheValueHolder(value, expire.toMillis());
            boolean success = this.client.getBucket(this.getCacheKey(key), this.getCodec()).setIfAbsent((Object)this.encoder(holder), expire);
            return success ? CacheResult.SUCCESS_WITHOUT_MSG : CacheResult.EXISTS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT_IF_ABSENT", key, e);
            return new CacheResult(e);
        }
    }
}

