/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.factory;

import com.alipay.easysdk.base.video.Client;
import com.alipay.easysdk.kernel.BaseClient;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class Factory {
    private static final Map<String, BaseClient> clients = new HashMap<String, BaseClient>();

    public static void setOptions(BaseClient.Config options) {
        try {
            Factory.registerClient(new com.alipay.easysdk.base.image.Client(options));
            Factory.registerClient(new Client(options));
            Factory.registerClient(new com.alipay.easysdk.base.oauth.Client(options));
            Factory.registerClient(new com.alipay.easysdk.base.qrcode.Client(options));
            Factory.registerClient(new com.alipay.easysdk.marketing.openlife.Client(options));
            Factory.registerClient(new com.alipay.easysdk.marketing.pass.Client(options));
            Factory.registerClient(new com.alipay.easysdk.marketing.templatemessage.Client(options));
            Factory.registerClient(new com.alipay.easysdk.member.identification.Client(options));
            Factory.registerClient(new com.alipay.easysdk.payment.common.Client(options));
            Factory.registerClient(new com.alipay.easysdk.payment.huabei.Client(options));
            Factory.registerClient(new com.alipay.easysdk.payment.facetoface.Client(options));
            Factory.registerClient(new com.alipay.easysdk.security.textrisk.Client(options));
            Factory.registerClient(new com.alipay.easysdk.util.generic.Client(options));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void registerClient(BaseClient client) {
        clients.put(client.getClass().getCanonicalName(), client);
    }

    private static <T> T getClient(Class<T> clazz) {
        BaseClient baseClient = clients.get(clazz.getCanonicalName());
        Preconditions.checkNotNull(baseClient, "\u5c1a\u672a\u6ce8\u518c" + clazz.getCanonicalName() + "\uff0c\u8bf7\u5148\u8c03\u7528Factory.setOptions\u65b9\u6cd5\u3002");
        return (T)baseClient;
    }

    public static class Util {
        public static com.alipay.easysdk.util.generic.Client Generic() {
            return (com.alipay.easysdk.util.generic.Client)Factory.getClient(com.alipay.easysdk.util.generic.Client.class);
        }
    }

    public static class Security {
        public static com.alipay.easysdk.security.textrisk.Client TextRisk() {
            return (com.alipay.easysdk.security.textrisk.Client)Factory.getClient(com.alipay.easysdk.security.textrisk.Client.class);
        }
    }

    public static class Member {
        public static com.alipay.easysdk.member.identification.Client Identification() {
            return (com.alipay.easysdk.member.identification.Client)Factory.getClient(com.alipay.easysdk.member.identification.Client.class);
        }
    }

    public static class Marketing {
        public static com.alipay.easysdk.marketing.openlife.Client OpenLife() {
            return (com.alipay.easysdk.marketing.openlife.Client)Factory.getClient(com.alipay.easysdk.marketing.openlife.Client.class);
        }

        public static com.alipay.easysdk.marketing.pass.Client Pass() {
            return (com.alipay.easysdk.marketing.pass.Client)Factory.getClient(com.alipay.easysdk.marketing.pass.Client.class);
        }

        public static com.alipay.easysdk.marketing.templatemessage.Client TemplateMessage() {
            return (com.alipay.easysdk.marketing.templatemessage.Client)Factory.getClient(com.alipay.easysdk.marketing.templatemessage.Client.class);
        }
    }

    public static class Base {
        public static com.alipay.easysdk.base.image.Client Image() {
            return (com.alipay.easysdk.base.image.Client)Factory.getClient(com.alipay.easysdk.base.image.Client.class);
        }

        public static Client Video() {
            return (Client)Factory.getClient(Client.class);
        }

        public static com.alipay.easysdk.base.oauth.Client OAuth() {
            return (com.alipay.easysdk.base.oauth.Client)Factory.getClient(com.alipay.easysdk.base.oauth.Client.class);
        }

        public static com.alipay.easysdk.base.qrcode.Client Qrcode() {
            return (com.alipay.easysdk.base.qrcode.Client)Factory.getClient(com.alipay.easysdk.base.qrcode.Client.class);
        }
    }

    public static class Payment {
        public static com.alipay.easysdk.payment.common.Client Common() {
            return (com.alipay.easysdk.payment.common.Client)Factory.getClient(com.alipay.easysdk.payment.common.Client.class);
        }

        public static com.alipay.easysdk.payment.huabei.Client Huabei() {
            return (com.alipay.easysdk.payment.huabei.Client)Factory.getClient(com.alipay.easysdk.payment.huabei.Client.class);
        }

        public static com.alipay.easysdk.payment.facetoface.Client FaceToFace() {
            return (com.alipay.easysdk.payment.facetoface.Client)Factory.getClient(com.alipay.easysdk.payment.facetoface.Client.class);
        }
    }
}

