/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel;

import com.alipay.easysdk.kernel.AlipayConstants;
import com.alipay.easysdk.kernel.CertEnvironment;
import com.alipay.easysdk.kernel.util.JsonUtil;
import com.alipay.easysdk.kernel.util.MultipartUtil;
import com.alipay.easysdk.kernel.util.PageUtil;
import com.alipay.easysdk.kernel.util.SignContentExtractor;
import com.alipay.easysdk.kernel.util.Signer;
import com.aliyun.tea.NameInMap;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.Validation;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class BaseClient {
    private final Signer signer = new Signer();
    private final SignContentExtractor signContentExtractor = new SignContentExtractor();
    private Map<String, Object> config;
    private CertEnvironment certEnvironment;

    protected BaseClient(Map<String, Object> config) {
        this.config = config;
        Preconditions.checkArgument("RSA2".equals(this.getConfig("signType")), "Alipay Easy SDK\u53ea\u5141\u8bb8\u4f7f\u7528RSA2\u7b7e\u540d\u65b9\u5f0f\uff0cRSA\u7b7e\u540d\u65b9\u5f0f\u7531\u4e8e\u5b89\u5168\u6027\u76f8\u6bd4RSA2\u5f31\u5df2\u4e0d\u518d\u63a8\u8350\u3002");
        if (!Strings.isNullOrEmpty(this.getConfig("alipayCertPath"))) {
            this.certEnvironment = new CertEnvironment(this.getConfig("merchantCertPath"), this.getConfig("alipayCertPath"), this.getConfig("alipayRootCertPath"));
        }
    }

    protected String _getConfig(String key) {
        return this.getConfig(key);
    }

    private String getConfig(String key) {
        return (String)this.config.get(key);
    }

    protected String _getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        return df.format(new Date());
    }

    protected byte[] _toUrlEncodedRequestBody(Map<String, Object> bizParams, Map<String, String> textParams) throws Exception {
        Map<String, String> sortedMap = this.getSortedMap(Collections.emptyMap(), bizParams, textParams);
        return this.buildQueryString(sortedMap).getBytes(AlipayConstants.DEFAULT_CHARSET);
    }

    private String buildQueryString(Map<String, String> sortedMap) throws UnsupportedEncodingException {
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, String> pair : sortedMap.entrySet()) {
            if (Strings.isNullOrEmpty(pair.getKey()) || Strings.isNullOrEmpty(pair.getValue())) continue;
            content.append(index == 0 ? "" : "&").append(pair.getKey()).append("=").append(URLEncoder.encode(pair.getValue(), AlipayConstants.DEFAULT_CHARSET.name()));
            ++index;
        }
        return content.toString();
    }

    protected String _getRandomBoundary() {
        return System.currentTimeMillis() + "";
    }

    protected String _concatStr(String a, String b) {
        return a + b;
    }

    protected InputStream _toMultipartRequestBody(Map<String, String> textParams, Map<String, String> fileParams, String boundary) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (Map.Entry<String, String> pair : textParams.entrySet()) {
            if (Strings.isNullOrEmpty(pair.getKey()) || Strings.isNullOrEmpty(pair.getValue())) continue;
            stream.write(MultipartUtil.getEntryBoundary(boundary));
            stream.write(MultipartUtil.getTextEntry(pair.getKey(), pair.getValue()));
        }
        for (Map.Entry<String, String> pair : fileParams.entrySet()) {
            if (Strings.isNullOrEmpty(pair.getKey()) || pair.getValue() == null) continue;
            stream.write(MultipartUtil.getEntryBoundary(boundary));
            stream.write(MultipartUtil.getFileEntry(pair.getKey(), pair.getValue()));
            stream.write(Files.toByteArray(new File(pair.getValue())));
        }
        stream.write(MultipartUtil.getEndBoundary(boundary));
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String _sign(Map<String, String> systemParams, Map<String, Object> bizParams, Map<String, String> textParams, String privateKey) throws Exception {
        Map<String, String> sortedMap = this.getSortedMap(systemParams, bizParams, textParams);
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, String> pair : sortedMap.entrySet()) {
            if (Strings.isNullOrEmpty(pair.getKey()) || Strings.isNullOrEmpty(pair.getValue())) continue;
            content.append(index == 0 ? "" : "&").append(pair.getKey()).append("=").append(pair.getValue());
            ++index;
        }
        return this.signer.sign(content.toString(), privateKey);
    }

    private Map<String, String> getSortedMap(Map<String, String> systemParams, Map<String, Object> bizParams, Map<String, String> textParams) throws Exception {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(systemParams);
        if (!bizParams.isEmpty()) {
            sortedMap.put("biz_content", JsonUtil.toJsonString(bizParams));
        }
        if (textParams != null) {
            sortedMap.putAll(textParams);
        }
        return sortedMap;
    }

    protected Map<String, Object> _readAsJson(TeaResponse response, String method) throws Exception {
        String responseBody = response.getResponseBody();
        Map map = new Gson().fromJson(responseBody, Map.class);
        map.put("http_body", responseBody);
        map.put("method", method);
        return map;
    }

    protected boolean _verify(Map<String, Object> respMap, String alipayPublicKey) {
        String sign = (String)respMap.get("sign");
        String content = this.signContentExtractor.getSignSourceData((String)respMap.get("http_body"), (String)respMap.get("method"));
        return this.signer.verify(content, sign, alipayPublicKey);
    }

    protected String _getMerchantCertSN() {
        if (this.certEnvironment == null) {
            return null;
        }
        return this.certEnvironment.getMerchantCertSN();
    }

    protected Map<String, Object> _toRespModel(Map<String, Object> respMap) {
        String methodName = (String)respMap.get("method");
        String responseNodeName = methodName.replace('.', '_') + "_response";
        String errorNodeName = "error_response";
        for (Map.Entry<String, Object> pair : respMap.entrySet()) {
            if (!responseNodeName.equals(pair.getKey())) continue;
            Map model = (Map)pair.getValue();
            model.put("http_body", respMap.get("http_body"));
            return model;
        }
        for (Map.Entry<String, Object> pair : respMap.entrySet()) {
            if (!errorNodeName.equals(pair.getKey())) continue;
            Map model = (Map)pair.getValue();
            model.put("http_body", respMap.get("http_body"));
            return model;
        }
        throw new RuntimeException("\u54cd\u5e94\u683c\u5f0f\u4e0d\u7b26\u5408\u9884\u671f\uff0c\u627e\u4e0d\u5230" + responseNodeName + "\u6216" + errorNodeName + "\u8282\u70b9");
    }

    protected String _getAlipayRootCertSN() {
        if (this.certEnvironment == null) {
            return null;
        }
        return this.certEnvironment.getRootCertSN();
    }

    protected boolean _isCertMode() {
        return this.certEnvironment != null;
    }

    protected String _getAlipayCertSN(Map<String, Object> respMap) {
        return (String)respMap.get("alipay_cert_sn");
    }

    protected String _extractAlipayPublicKey(String alipayCertSN) {
        if (this.certEnvironment == null) {
            return null;
        }
        return this.certEnvironment.getAlipayPublicKey(alipayCertSN);
    }

    protected String _generatePage(String method, Map<String, String> systemParams, Map<String, Object> bizParams, Map<String, String> textParams, String sign) throws Exception {
        if ("GET".equalsIgnoreCase(method)) {
            Map<String, String> sortedMap = this.getSortedMap(systemParams, bizParams, textParams);
            sortedMap.put("sign", sign);
            return this.getGatewayServerUrl() + "?" + this.buildQueryString(sortedMap);
        }
        if ("POST".equalsIgnoreCase(method)) {
            TreeMap<String, String> urlParams = new TreeMap<String, String>(systemParams);
            urlParams.put("sign", sign);
            String actionUrl = this.getGatewayServerUrl() + "?" + this.buildQueryString(urlParams);
            TreeMap<String, String> formParams = new TreeMap<String, String>(textParams);
            formParams.put("biz_content", JsonUtil.toJsonString(bizParams));
            return PageUtil.buildForm(actionUrl, formParams);
        }
        throw new RuntimeException("_generatePage\u4e2dmethod\u53ea\u652f\u6301\u4f20\u5165GET\u6216POST");
    }

    private String getGatewayServerUrl() {
        return this.getConfig("protocol") + "://" + this.getConfig("gatewayHost") + "/gateway.do";
    }

    protected String _getSdkVersion() {
        return "alipay-easysdk-java-1.1.0";
    }

    public static class Config
    extends TeaModel {
        @NameInMap(value="protocol")
        @Validation(required=true)
        public String protocol;
        @NameInMap(value="gatewayHost")
        @Validation(required=true)
        public String gatewayHost;
        @NameInMap(value="appId")
        @Validation(required=true)
        public String appId;
        @NameInMap(value="signType")
        @Validation(required=true)
        public String signType;
        @NameInMap(value="alipayPublicKey")
        public String alipayPublicKey;
        @NameInMap(value="merchantPrivateKey")
        @Validation(required=true)
        public String merchantPrivateKey;
        @NameInMap(value="merchantCertPath")
        public String merchantCertPath;
        @NameInMap(value="alipayCertPath")
        public String alipayCertPath;
        @NameInMap(value="alipayRootCertPath")
        public String alipayRootCertPath;
    }
}

