/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.util.generic;

import com.alipay.easysdk.kernel.BaseClient;
import com.alipay.easysdk.util.generic.models.AlipayOpenApiGenericResponse;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.Map;

public class Client
extends BaseClient {
    public Client(BaseClient.Config config) throws Exception {
        super(TeaModel.buildMap(config));
    }

    public AlipayOpenApiGenericResponse execute(String method, Map<String, String> textParams, Map<String, Object> bizParams) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", method), new TeaPair("app_id", this._getConfig("appId")), new TeaPair("timestamp", this._getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._getConfig("signType")), new TeaPair("app_cert_sn", this._getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._getAlipayRootCertSN()));
                request_.protocol = this._getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._sign(systemParams, bizParams, textParams, this._getConfig("merchantPrivateKey")))), systemParams);
                request_.body = Tea.toReadable(this._toUrlEncodedRequestBody(bizParams, textParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._readAsJson(response_, method);
                if (this._isCertMode() ? this._verify(respMap, this._extractAlipayPublicKey(this._getAlipayCertSN(respMap))) : this._verify(respMap, this._getConfig("alipayPublicKey"))) {
                    return TeaModel.toModel(this._toRespModel(respMap), new AlipayOpenApiGenericResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }
}

