/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerManager
implements Lifecycle<Integer> {
    private ScheduledExecutorService executor;

    @Override
    public boolean init(Integer coreSize) {
        this.executor = Executors.newScheduledThreadPool(coreSize, new NamedThreadFactory("JRaft-Node-ScheduleThreadPool-"));
        return true;
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private void checkStarted() {
        if (this.executor == null) {
            throw new IllegalStateException("Please init timer manager.");
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkStarted();
        return this.executor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.checkStarted();
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.checkStarted();
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

