/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.exception.InvokeTimeoutException;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.ClientService;
import com.alipay.sofa.jraft.rpc.ProtobufMsgFactory;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.rpc.impl.FutureImpl;
import com.alipay.sofa.jraft.rpc.impl.core.BoltRaftClientService;
import com.alipay.sofa.jraft.rpc.impl.core.JraftRpcAddressParser;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.ThreadPoolMetricSet;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.Utils;
import com.codahale.metrics.Metric;
import com.google.protobuf.Message;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoltClientService
implements ClientService {
    protected static final Logger LOG = LoggerFactory.getLogger(BoltRaftClientService.class);
    protected RpcClient rpcClient;
    protected ThreadPoolExecutor rpcExecutor;
    protected RpcOptions rpcOptions;
    protected JraftRpcAddressParser rpcAddressParser;

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    @Override
    public boolean isConnected(Endpoint endpoint) {
        return this.rpcClient.checkConnection(endpoint.toString());
    }

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        if (this.rpcClient != null) {
            return true;
        }
        this.rpcOptions = rpcOptions;
        int rpcProcessorThreadPoolSize = this.rpcOptions.getRpcProcessorThreadPoolSize();
        this.rpcAddressParser = new JraftRpcAddressParser();
        return this.initRpcClient(rpcProcessorThreadPoolSize);
    }

    protected void configRpcClient(RpcClient rpcClient) {
    }

    protected boolean initRpcClient(int rpcProcessorThreadPoolSize) {
        this.rpcClient = new RpcClient();
        this.configRpcClient(this.rpcClient);
        this.rpcClient.init();
        this.rpcExecutor = ThreadPoolUtil.newThreadPool("JRaft-RPC-Processor", true, rpcProcessorThreadPoolSize / 3, rpcProcessorThreadPoolSize, 60L, new ArrayBlockingQueue<Runnable>(10000), new NamedThreadFactory("JRaft-RPC-Processor-"));
        if (this.rpcOptions.getMetricRegistry() != null) {
            this.rpcOptions.getMetricRegistry().register("raft-rpc-client-thread-pool", (Metric)new ThreadPoolMetricSet(this.rpcExecutor));
            Utils.registerClosureExecutorMetrics(this.rpcOptions.getMetricRegistry());
        }
        return true;
    }

    @Override
    public synchronized void shutdown() {
        if (this.rpcClient != null) {
            this.rpcClient.shutdown();
            this.rpcClient = null;
            this.rpcExecutor.shutdown();
        }
    }

    @Override
    public boolean connect(Endpoint endpoint) {
        if (this.rpcClient == null) {
            throw new IllegalStateException("Client service is not inited.");
        }
        if (this.isConnected(endpoint)) {
            return true;
        }
        try {
            RpcRequests.PingRequest req = RpcRequests.PingRequest.newBuilder().setSendTimestamp(System.currentTimeMillis()).build();
            RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)this.rpcClient.invokeSync(endpoint.toString(), (Object)req, this.rpcOptions.getRpcConnectTimeoutMs());
            return resp.getErrorCode() == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (RemotingException e) {
            LOG.error("Fail to connect {}, remoting exception: {}", (Object)endpoint, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean disconnect(Endpoint endpoint) {
        LOG.info("Disconnect from {}", (Object)endpoint);
        this.rpcClient.closeConnection(endpoint.toString());
        return true;
    }

    @Override
    public <T extends Message> Future<Message> invokeWithDone(Endpoint endpoint, final Message request, final RpcResponseClosure<T> done, int timeoutMs) {
        final FutureImpl<Message> future = new FutureImpl<Message>();
        try {
            Url rpcUrl = this.rpcAddressParser.parse(endpoint.toString());
            this.rpcClient.invokeWithCallback(rpcUrl, (Object)request, new InvokeCallback(){

                public void onResponse(Object result) {
                    if (future.isCancelled()) {
                        return;
                    }
                    Status status = Status.OK();
                    if (result instanceof RpcRequests.ErrorResponse) {
                        RpcRequests.ErrorResponse eResp = (RpcRequests.ErrorResponse)result;
                        status = new Status();
                        status.setCode(eResp.getErrorCode());
                        if (eResp.hasErrorMsg()) {
                            status.setErrorMsg(eResp.getErrorMsg());
                        }
                    } else if (done != null) {
                        done.setResponse((Message)result);
                    }
                    if (done != null) {
                        try {
                            done.run(status);
                        }
                        catch (Throwable t) {
                            LOG.error("Fail to run RpcResponseClosure, the request is {}", (Object)request, (Object)t);
                        }
                    }
                    if (!future.isDone()) {
                        future.setResult((Message)result);
                    }
                }

                public void onException(Throwable e) {
                    if (future.isCancelled()) {
                        return;
                    }
                    if (done != null) {
                        try {
                            done.run(new Status(e instanceof InvokeTimeoutException ? RaftError.ETIMEDOUT : RaftError.EINTERNAL, "RPC exception:" + e.getMessage(), new Object[0]));
                        }
                        catch (Throwable t) {
                            LOG.error("Fail to run RpcResponseClosure, the request is {}", (Object)request, (Object)t);
                        }
                    }
                    if (!future.isDone()) {
                        future.failure(e);
                    }
                }

                public Executor getExecutor() {
                    return AbstractBoltClientService.this.rpcExecutor;
                }
            }, timeoutMs <= 0 ? this.rpcOptions.getRpcDefaultTimeout() : timeoutMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.failure(e);
            Utils.runClosureInThread(done, new Status(RaftError.EINTR, "Sending rpc was interrupted", new Object[0]));
        }
        catch (RemotingException e) {
            future.failure(e);
            Utils.runClosureInThread(done, new Status(RaftError.EINTERNAL, "Fail to send a RPC request:" + e.getMessage(), new Object[0]));
        }
        return future;
    }

    static {
        ProtobufMsgFactory.load();
    }
}

