/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.core;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.jraft.rpc.impl.core.ClientServiceConnectionEventProcessor;
import com.alipay.sofa.jraft.util.Endpoint;
import com.google.protobuf.Message;
import java.util.concurrent.Future;

public class BoltRaftClientService
extends AbstractBoltClientService
implements RaftClientService {
    private NodeOptions nodeOptions;
    private final ReplicatorGroup rgGroup;

    @Override
    protected void configRpcClient(RpcClient rpcClient) {
        rpcClient.addConnectionEventProcessor(ConnectionEventType.CONNECT, (ConnectionEventProcessor)new ClientServiceConnectionEventProcessor(this.rgGroup));
    }

    public BoltRaftClientService(ReplicatorGroup rgGroup) {
        this.rgGroup = rgGroup;
    }

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        boolean ret = super.init(rpcOptions);
        if (ret) {
            this.nodeOptions = (NodeOptions)rpcOptions;
        }
        return ret;
    }

    @Override
    public Future<Message> preVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> requestVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> appendEntries(Endpoint endpoint, RpcRequests.AppendEntriesRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.AppendEntriesResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }

    @Override
    public Future<Message> getFile(Endpoint endpoint, RpcRequests.GetFileRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.GetFileResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }

    @Override
    public Future<Message> installSnapshot(Endpoint endpoint, RpcRequests.InstallSnapshotRequest request, RpcResponseClosure<RpcRequests.InstallSnapshotResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.rpcOptions.getRpcDefaultTimeout());
    }

    @Override
    public Future<Message> timeoutNow(Endpoint endpoint, RpcRequests.TimeoutNowRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.TimeoutNowResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }

    @Override
    public Future<Message> readIndex(Endpoint endpoint, RpcRequests.ReadIndexRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.ReadIndexResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }
}

