/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ClientProxyInvoker;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.invoke.SendableResponseCallback;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.message.ResponseFuture;

public class DefaultClientProxyInvoker
extends ClientProxyInvoker {
    private String serviceName;
    private Byte serializeType;

    public DefaultClientProxyInvoker(ConsumerBootstrap bootstrap) {
        super(bootstrap);
        this.cacheCommonData();
    }

    private void cacheCommonData() {
        this.serviceName = ConfigUniqueNameGenerator.getUniqueName(this.consumerConfig);
        this.serializeType = this.parseSerializeType(this.consumerConfig.getSerialization());
    }

    private Byte parseSerializeType(String serialization) {
        Byte serializeType;
        if ("hessian".equals(serialization) || "hessian2".equals(serialization)) {
            serializeType = 1;
        } else if ("protobuf".equals(serialization)) {
            serializeType = 11;
        } else if ("java".equals(serialization)) {
            serializeType = 2;
        } else {
            throw new SofaRpcRuntimeException("Unsupported serialization type");
        }
        return serializeType;
    }

    @Override
    protected void decorateRequest(SofaRequest request) {
        super.decorateRequest(request);
        request.setTargetServiceUniqueName(this.serviceName);
        request.setSerializeType(this.serializeType);
        if (!this.consumerConfig.isGeneric()) {
            request.setInvokeType(this.consumerConfig.getMethodInvokeType(request.getMethodName()));
        }
        RpcInvokeContext invokeCtx = RpcInvokeContext.peekContext();
        RpcInternalContext internalContext = RpcInternalContext.getContext();
        if (invokeCtx != null) {
            String targetURL;
            Integer timeout;
            SofaResponseCallback responseCallback = invokeCtx.getResponseCallback();
            if (responseCallback != null) {
                request.setSofaResponseCallback(responseCallback);
                invokeCtx.setResponseCallback(null);
                invokeCtx.put("rpc.async.chain", this.isSendableResponseCallback(responseCallback));
            }
            if ((timeout = invokeCtx.getTimeout()) != null) {
                request.setTimeout(timeout);
                invokeCtx.setTimeout(null);
            }
            if ((targetURL = invokeCtx.getTargetURL()) != null) {
                internalContext.setAttachment(".pinpoint", targetURL);
                invokeCtx.setTargetURL(null);
            }
            if (RpcInvokeContext.isBaggageEnable()) {
                BaggageResolver.carryWithRequest(invokeCtx, request);
                internalContext.setAttachment(".invoke_ctx", invokeCtx);
            }
        }
        if (RpcInternalContext.isAttachmentEnable()) {
            internalContext.setAttachment("_app_name", this.consumerConfig.getAppName());
            internalContext.setAttachment("_protocol_name", this.consumerConfig.getProtocol());
        }
        request.addRequestProp("app", this.consumerConfig.getAppName());
        request.addRequestProp("protocol", this.consumerConfig.getProtocol());
    }

    @Override
    protected void decorateResponse(SofaResponse response) {
        String resultCode;
        super.decorateResponse(response);
        RpcInternalContext context = RpcInternalContext.getContext();
        ResponseFuture future = context.getFuture();
        RpcInvokeContext invokeCtx = null;
        if (future != null) {
            invokeCtx = RpcInvokeContext.getContext();
            invokeCtx.setFuture(future);
        }
        if (RpcInvokeContext.isBaggageEnable()) {
            BaggageResolver.pickupFromResponse(invokeCtx, response, true);
        }
        if (RpcInternalContext.isAttachmentEnable() && (resultCode = (String)context.getAttachment("_result_code")) != null) {
            if (invokeCtx == null) {
                invokeCtx = RpcInvokeContext.getContext();
            }
            invokeCtx.put("rpc.result.code", resultCode);
        }
    }

    protected boolean isSendableResponseCallback(SofaResponseCallback callback) {
        return callback instanceof SendableResponseCallback;
    }

    @Override
    public Cluster setCluster(Cluster newCluster) {
        Cluster old = super.setCluster(newCluster);
        this.cacheCommonData();
        return old;
    }

    public String toString() {
        return this.consumerConfig != null ? ConfigUniqueNameGenerator.getUniqueName(this.consumerConfig) : super.toString();
    }
}

