/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderHelper {
    public static void compareGroup(ProviderGroup oldGroup, ProviderGroup newGroup, List<ProviderInfo> add, List<ProviderInfo> remove) {
        ProviderHelper.compareProviders(oldGroup.getProviderInfos(), newGroup.getProviderInfos(), add, remove);
    }

    public static void compareProviders(List<ProviderInfo> oldList, List<ProviderInfo> newList, List<ProviderInfo> add, List<ProviderInfo> remove) {
        if (CommonUtils.isEmpty(oldList)) {
            if (CommonUtils.isNotEmpty(newList)) {
                add.addAll(newList);
            }
        } else if (CommonUtils.isEmpty(newList)) {
            remove.addAll(oldList);
        } else if (CommonUtils.isNotEmpty(oldList)) {
            ArrayList<ProviderInfo> tmpList = new ArrayList<ProviderInfo>(newList);
            for (ProviderInfo oldProvider : oldList) {
                if (tmpList.contains(oldProvider)) {
                    tmpList.remove(oldProvider);
                    continue;
                }
                remove.add(oldProvider);
            }
            add.addAll(tmpList);
        }
    }

    public static void compareGroups(List<ProviderGroup> oldGroups, List<ProviderGroup> newGroups, List<ProviderInfo> add, List<ProviderInfo> remove) {
        block9: {
            block8: {
                if (!CommonUtils.isEmpty(oldGroups)) break block8;
                if (!CommonUtils.isNotEmpty(newGroups)) break block9;
                for (ProviderGroup newGroup : newGroups) {
                    add.addAll(newGroup.getProviderInfos());
                }
                break block9;
            }
            if (CommonUtils.isEmpty(newGroups)) {
                for (ProviderGroup oldGroup : oldGroups) {
                    remove.addAll(oldGroup.getProviderInfos());
                }
            } else if (CommonUtils.isNotEmpty(oldGroups)) {
                Map<String, List<ProviderInfo>> oldMap = ProviderHelper.convertToMap(oldGroups);
                Map<String, List<ProviderInfo>> mapTmp = ProviderHelper.convertToMap(newGroups);
                for (Map.Entry<String, List<ProviderInfo>> oldEntry : oldMap.entrySet()) {
                    String key = oldEntry.getKey();
                    List<ProviderInfo> oldList = oldEntry.getValue();
                    if (mapTmp.containsKey(key)) {
                        List<ProviderInfo> newList = mapTmp.remove(key);
                        ProviderHelper.compareProviders(oldList, newList, add, remove);
                        mapTmp.remove(key);
                        continue;
                    }
                    remove.addAll(oldList);
                }
                for (Map.Entry<String, List<ProviderInfo>> entry : mapTmp.entrySet()) {
                    add.addAll((Collection<ProviderInfo>)entry.getValue());
                }
            }
        }
    }

    private static Map<String, List<ProviderInfo>> convertToMap(List<ProviderGroup> providerGroups) {
        HashMap<String, List<ProviderInfo>> map = new HashMap<String, List<ProviderInfo>>(providerGroups.size());
        for (ProviderGroup providerGroup : providerGroups) {
            ArrayList<ProviderInfo> ps = (ArrayList<ProviderInfo>)map.get(providerGroup.getName());
            if (ps == null) {
                ps = new ArrayList<ProviderInfo>();
                map.put(providerGroup.getName(), ps);
            }
            ps.addAll(providerGroup.getProviderInfos());
        }
        return map;
    }

    public static boolean isEmpty(ProviderGroup group) {
        return group == null || group.isEmpty();
    }
}

