/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProviderInfo
implements Serializable {
    private static final long serialVersionUID = -6438690329875954051L;
    private transient String originUrl;
    private String protocolType = RpcConfigs.getStringValue("default.protocol");
    private String host;
    private int port = 80;
    private String path;
    private String serializationType;
    private int rpcVersion;
    private volatile transient int weight = RpcConfigs.getIntValue("provider.weight");
    private volatile transient ProviderStatus status = ProviderStatus.AVAILABLE;
    private final ConcurrentHashMap<String, String> staticAttrs = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<String, Object> dynamicAttrs = new ConcurrentHashMap();

    public ProviderInfo() {
    }

    public ProviderInfo(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ProviderInfo(String host, int port, String originUrl) {
        this.host = host;
        this.port = port;
        this.originUrl = originUrl;
    }

    private ProviderInfo(String url) {
        this.setOriginUrl(url);
        try {
            String address;
            String remainUrl;
            int protocolIndex = url.indexOf("://");
            if (protocolIndex > -1) {
                String protocol = url.substring(0, protocolIndex).toLowerCase();
                this.setProtocolType(protocol);
                remainUrl = url.substring(protocolIndex + 3);
            } else {
                remainUrl = url;
            }
            int addressIndex = remainUrl.indexOf("/");
            if (addressIndex > -1) {
                address = remainUrl.substring(0, addressIndex);
                remainUrl = remainUrl.substring(addressIndex);
            } else {
                int itfIndex = remainUrl.indexOf(63);
                if (itfIndex > -1) {
                    address = remainUrl.substring(0, itfIndex);
                    remainUrl = remainUrl.substring(itfIndex);
                } else {
                    address = remainUrl;
                    remainUrl = "";
                }
            }
            String[] ipAndPort = address.split(":", -1);
            this.setHost(ipAndPort[0]);
            if (ipAndPort.length > 1) {
                this.setPort(CommonUtils.parseInt(ipAndPort[1], this.port));
            }
            if (remainUrl.length() > 0) {
                int itfIndex = remainUrl.indexOf(63);
                if (itfIndex > -1) {
                    String[] params;
                    String itf = remainUrl.substring(0, itfIndex);
                    this.setPath(itf);
                    remainUrl = remainUrl.substring(itfIndex + 1);
                    for (String parm : params = remainUrl.split("&", -1)) {
                        String[] kvpair = parm.split("=", -1);
                        if ("weight".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            int weight = CommonUtils.parseInt(kvpair[1], this.getWeight());
                            this.setWeight(weight);
                            this.setStaticAttr("weight", String.valueOf(weight));
                            continue;
                        }
                        if ("rpcVer".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            this.setRpcVersion(CommonUtils.parseInt(kvpair[1], this.getRpcVersion()));
                            continue;
                        }
                        if ("serialization".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            this.setSerializationType(kvpair[1]);
                            continue;
                        }
                        this.staticAttrs.put(kvpair[0], kvpair[1]);
                    }
                } else {
                    String itf = remainUrl;
                    this.setPath(itf);
                }
            } else {
                this.setPath("");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert url to provider, the wrong url is:" + url, e);
        }
    }

    public static ProviderInfo valueOf(String url) {
        return new ProviderInfo(url);
    }

    public String toUrl() {
        String uri = this.protocolType + "://" + this.host + ":" + this.port;
        uri = uri + StringUtils.trimToEmpty(this.path);
        StringBuilder sb = new StringBuilder();
        if (this.rpcVersion > 0) {
            sb.append("&").append("rpcVer").append("=").append(this.rpcVersion);
        }
        if (this.serializationType != null) {
            sb.append("&").append("serialization").append("=").append(this.serializationType);
        }
        for (Map.Entry<String, String> entry : this.staticAttrs.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            uri = uri + sb.replace(0, 1, "?").toString();
        }
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderInfo that = (ProviderInfo)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.rpcVersion != that.rpcVersion) {
            return false;
        }
        if (this.protocolType != null ? !this.protocolType.equals(that.protocolType) : that.protocolType != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.serializationType != null ? !this.serializationType.equals(that.serializationType) : that.serializationType != null);
    }

    public int hashCode() {
        int result = this.protocolType != null ? this.protocolType.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.serializationType != null ? this.serializationType.hashCode() : 0);
        result = 31 * result + this.rpcVersion;
        return result;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public ProviderInfo setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
        return this;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public ProviderInfo setProtocolType(String protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ProviderInfo setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProviderInfo setPort(int port) {
        this.port = port;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public ProviderInfo setPath(String path) {
        this.path = path;
        return this;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public ProviderInfo setSerializationType(String serializationType) {
        this.serializationType = serializationType;
        return this;
    }

    public int getWeight() {
        ProviderStatus status = this.getStatus();
        if (status == ProviderStatus.WARMING_UP) {
            try {
                Integer warmUpWeight = (Integer)this.getDynamicAttr("warmupWeight");
                if (warmUpWeight != null) {
                    return warmUpWeight;
                }
            }
            catch (Exception e) {
                return this.weight;
            }
        }
        return this.weight;
    }

    public ProviderInfo setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getRpcVersion() {
        return this.rpcVersion;
    }

    public ProviderInfo setRpcVersion(int rpcVersion) {
        this.rpcVersion = rpcVersion;
        return this;
    }

    public ProviderStatus getStatus() {
        if (this.status == ProviderStatus.WARMING_UP && System.currentTimeMillis() > (Long)this.getDynamicAttr("warmupEndTime")) {
            this.status = ProviderStatus.AVAILABLE;
            this.setDynamicAttr("warmupEndTime", null);
        }
        return this.status;
    }

    public ProviderInfo setStatus(ProviderStatus status) {
        this.status = status;
        return this;
    }

    public ConcurrentHashMap<String, String> getStaticAttrs() {
        return this.staticAttrs;
    }

    public ProviderInfo setStaticAttrs(Map<String, String> staticAttrs) {
        this.staticAttrs.clear();
        this.staticAttrs.putAll(staticAttrs);
        return this;
    }

    public ConcurrentHashMap<String, Object> getDynamicAttrs() {
        return this.dynamicAttrs;
    }

    public ProviderInfo setDynamicAttrs(Map<String, Object> dynamicAttrs) {
        this.dynamicAttrs.clear();
        this.dynamicAttrs.putAll(dynamicAttrs);
        return this;
    }

    public String getStaticAttr(String staticAttrKey) {
        return this.staticAttrs.get(staticAttrKey);
    }

    public ProviderInfo setStaticAttr(String staticAttrKey, String staticAttrValue) {
        if (staticAttrValue == null) {
            this.staticAttrs.remove(staticAttrKey);
        } else {
            this.staticAttrs.put(staticAttrKey, staticAttrValue);
        }
        return this;
    }

    public Object getDynamicAttr(String dynamicAttrKey) {
        return this.dynamicAttrs.get(dynamicAttrKey);
    }

    public ProviderInfo setDynamicAttr(String dynamicAttrKey, Object dynamicAttrValue) {
        if (dynamicAttrValue == null) {
            this.dynamicAttrs.remove(dynamicAttrKey);
        } else {
            this.dynamicAttrs.put(dynamicAttrKey, dynamicAttrValue);
        }
        return this;
    }

    public String toString() {
        return this.originUrl == null ? this.host + ":" + this.port : this.originUrl;
    }

    public String getAttr(String key) {
        String val = (String)this.dynamicAttrs.get(key);
        return val == null ? this.staticAttrs.get(key) : val;
    }
}

