/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.aft.DegradeStrategy;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStat;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.InvocationStatFactory;
import com.alipay.sofa.rpc.client.aft.MeasureModel;
import com.alipay.sofa.rpc.client.aft.MeasureResult;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.client.aft.MeasureState;
import com.alipay.sofa.rpc.client.aft.MeasureStrategy;
import com.alipay.sofa.rpc.client.aft.RecoverStrategy;
import com.alipay.sofa.rpc.client.aft.RegulationStrategy;
import com.alipay.sofa.rpc.client.aft.Regulator;
import com.alipay.sofa.rpc.client.aft.impl.LogPrintDegradeStrategy;
import com.alipay.sofa.rpc.client.aft.impl.ServiceHorizontalMeasureStrategy;
import com.alipay.sofa.rpc.client.aft.impl.ServiceHorizontalRegulationStrategy;
import com.alipay.sofa.rpc.client.aft.impl.WeightDegradeStrategy;
import com.alipay.sofa.rpc.client.aft.impl.WeightRecoverStrategy;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.struct.ScheduledService;
import com.alipay.sofa.rpc.common.utils.ThreadPoolUtils;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeWindowRegulator
implements Regulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeWindowRegulator.class);
    private final AtomicInteger measureCounter = new AtomicInteger();
    private final ScheduledService measureScheduler = new ScheduledService("SOFA-AFT-MEASURE", 0, new MeasureRunnable(), 1L, 1L, TimeUnit.SECONDS);
    private final AtomicBoolean measureStarted = new AtomicBoolean();
    private final ExecutorService regulationExecutor = ThreadPoolUtils.newFixedThreadPool(2, new LinkedBlockingQueue<Runnable>(16), new NamedThreadFactory("SOFA-AFT-REGULATION"));
    private final CopyOnWriteArrayList<MeasureModel> measureModels = new CopyOnWriteArrayList();
    private MeasureStrategy measureStrategy;
    private RegulationStrategy regulationStrategy;
    private DegradeStrategy weightDegradeStrategy;
    private DegradeStrategy logDegradeStrategy;
    private RecoverStrategy recoverStrategy;
    private final InvocationStatFactory.InvocationStatListener listener = new TimeWindowRegulatorListener();

    @Override
    public void init() {
        this.measureStrategy = new ServiceHorizontalMeasureStrategy();
        this.regulationStrategy = new ServiceHorizontalRegulationStrategy();
        this.weightDegradeStrategy = new WeightDegradeStrategy();
        this.logDegradeStrategy = new LogPrintDegradeStrategy();
        this.recoverStrategy = new WeightRecoverStrategy();
        InvocationStatFactory.addListener(this.listener);
    }

    @Override
    public void startRegulate() {
        if (this.measureStarted.compareAndSet(false, true)) {
            this.measureScheduler.start();
        }
    }

    @Override
    public void stopRegulate() {
        if (this.measureStarted.compareAndSet(true, false)) {
            this.measureScheduler.stop();
        }
    }

    @Override
    public void destroy() {
        this.stopRegulate();
        InvocationStatFactory.removeListener(this.listener);
        this.measureModels.clear();
        this.measureCounter.set(0);
        this.measureStrategy = null;
        this.regulationStrategy = null;
        this.weightDegradeStrategy = null;
        this.logDegradeStrategy = null;
        this.recoverStrategy = null;
    }

    class TimeWindowRegulatorListener
    implements InvocationStatFactory.InvocationStatListener {
        TimeWindowRegulatorListener() {
        }

        @Override
        public void onAddInvocationStat(InvocationStat invocationStat) {
            MeasureModel measureModel;
            if (TimeWindowRegulator.this.measureStrategy != null && (measureModel = TimeWindowRegulator.this.measureStrategy.buildMeasureModel(invocationStat)) != null) {
                TimeWindowRegulator.this.measureModels.add(measureModel);
                TimeWindowRegulator.this.startRegulate();
            }
        }

        @Override
        public void onRemoveInvocationStat(InvocationStat invocationStat) {
            if (TimeWindowRegulator.this.measureStrategy != null) {
                TimeWindowRegulator.this.measureStrategy.removeMeasureModel(invocationStat);
            }
        }
    }

    private class RegulationRunnable
    implements Runnable {
        private final MeasureResult measureResult;

        RegulationRunnable(MeasureResult measureResult) {
            this.measureResult = measureResult;
        }

        @Override
        public void run() {
            List<MeasureResultDetail> measureResultDetails = this.measureResult.getAllMeasureResultDetails();
            for (MeasureResultDetail measureResultDetail : measureResultDetails) {
                try {
                    this.doRegulate(measureResultDetail);
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(this.measureResult.getMeasureModel().getAppName(), "Error when doRegulate: " + e.getMessage(), e);
                }
            }
        }

        void doRegulate(MeasureResultDetail measureResultDetail) {
            MeasureState measureState = measureResultDetail.getMeasureState();
            InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
            boolean isDegradeEffective = TimeWindowRegulator.this.regulationStrategy.isDegradeEffective(measureResultDetail);
            if (isDegradeEffective) {
                boolean isExistDegradeList;
                if (measureState.equals((Object)MeasureState.ABNORMAL)) {
                    boolean isReachMaxDegradeIpCount = TimeWindowRegulator.this.regulationStrategy.isReachMaxDegradeIpCount(measureResultDetail);
                    if (!isReachMaxDegradeIpCount) {
                        TimeWindowRegulator.this.weightDegradeStrategy.degrade(measureResultDetail);
                    } else {
                        String appName = this.measureResult.getMeasureModel().getAppName();
                        if (LOGGER.isInfoEnabled(appName)) {
                            LOGGER.infoWithApp(appName, LogCodes.getLog("00217", "Reach degrade number limit.", statDimension.getService(), statDimension.getIp(), statDimension.getAppName()));
                        }
                    }
                } else if (measureState.equals((Object)MeasureState.HEALTH) && (isExistDegradeList = TimeWindowRegulator.this.regulationStrategy.isExistInTheDegradeList(measureResultDetail))) {
                    TimeWindowRegulator.this.recoverStrategy.recover(measureResultDetail);
                    TimeWindowRegulator.this.regulationStrategy.removeFromDegradeList(measureResultDetail);
                }
            } else if (measureState.equals((Object)MeasureState.ABNORMAL)) {
                TimeWindowRegulator.this.logDegradeStrategy.degrade(measureResultDetail);
                String appName = this.measureResult.getMeasureModel().getAppName();
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00217", "Degrade switch is off", statDimension.getService(), statDimension.getIp(), statDimension.getAppName()));
                }
            }
        }
    }

    private class MeasureRunnable
    implements Runnable {
        private MeasureRunnable() {
        }

        @Override
        public void run() {
            TimeWindowRegulator.this.measureCounter.incrementAndGet();
            for (MeasureModel measureModel : TimeWindowRegulator.this.measureModels) {
                try {
                    if (!this.isArriveTimeWindow(measureModel)) continue;
                    MeasureResult measureResult = TimeWindowRegulator.this.measureStrategy.measure(measureModel);
                    TimeWindowRegulator.this.regulationExecutor.submit(new RegulationRunnable(measureResult));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(measureModel.getAppName(), "Error when doMeasure: " + e.getMessage(), e);
                }
            }
        }

        private boolean isArriveTimeWindow(MeasureModel measureModel) {
            long timeWindow = FaultToleranceConfigManager.getTimeWindow(measureModel.getAppName());
            return (long)TimeWindowRegulator.this.measureCounter.get() % timeWindow == 0L;
        }
    }
}

