/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.anthessian;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.caucho.hessian.io.ArrayDeserializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;

public class SingleClassLoaderSofaSerializerFactory
extends SerializerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleClassLoaderSofaSerializerFactory.class);

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        return new JavaSerializer(cl);
    }

    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        if (StringUtils.isEmpty(type)) {
            return null;
        }
        Deserializer deserializer = this.getDeserializerFromCachedType(type);
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = (Deserializer)_staticTypeMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type.startsWith("[")) {
            Deserializer subDeserializer = this.getDeserializer(type.substring(1));
            deserializer = new ArrayDeserializer(subDeserializer);
        } else {
            try {
                ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(type, true, appClassLoader);
                deserializer = this.getDeserializer(cl);
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) {
                    LOGGER.errorWithApp(null, LogCodes.getLog("02406", ((Object)((Object)this)).getClass().getName(), type, Thread.currentThread().getContextClassLoader()));
                }
                LOGGER.errorWithApp(null, e.toString(), e);
            }
        }
        if (deserializer != null) {
            this.putDeserializerToCachedType(type, deserializer);
        }
        return deserializer;
    }

    protected Deserializer getDeserializerFromCachedType(String type) {
        return (Deserializer)this._cachedTypeDeserializerMap.get(type);
    }

    protected void putDeserializerToCachedType(String type, Deserializer deserializer) {
        this._cachedTypeDeserializerMap.put(type, deserializer);
    }
}

