/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.antpb;

import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.sofa.rpc.common.RpcConstants;
import com.google.protobuf.MessageLite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;

public class ProtobufSerializer {
    private ConcurrentHashMap<Class, Method> parseMethodMap = new ConcurrentHashMap();
    private static ProtobufSerializer instance = new ProtobufSerializer();
    private static ConcurrentHashMap<String, Class> REQUEST_CLASS_CACHE = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Class> RESPONSE_CLASS_CACHE = new ConcurrentHashMap();

    private ProtobufSerializer() {
    }

    public static ProtobufSerializer getInstance() {
        return instance;
    }

    public byte[] encode(Object object) throws SerializationException {
        if (object == null) {
            throw new SerializationException("Unsupported null message");
        }
        if (object instanceof MessageLite) {
            MessageLite lite = (MessageLite)object;
            return lite.toByteArray();
        }
        if (object instanceof String) {
            return ((String)object).getBytes(RpcConstants.DEFAULT_CHARSET);
        }
        throw new SerializationException("Unsupported class:" + object.getClass().getName() + ", only support protobuf message");
    }

    public Object decode(byte[] bytes, Class clazz) throws DeserializationException {
        if (MessageLite.class.isAssignableFrom(clazz)) {
            try {
                Method method = this.parseMethodMap.get(clazz);
                if (method == null) {
                    method = clazz.getMethod("parseFrom", byte[].class);
                    if (!Modifier.isStatic(method.getModifiers())) {
                        throw new CodecException("Cannot found method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code");
                    }
                    method.setAccessible(true);
                    this.parseMethodMap.put(clazz, method);
                }
                return method.invoke(null, new Object[]{bytes});
            }
            catch (DeserializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeserializationException("Cannot found method " + clazz.getName() + ".parseFrom(byte[]), please check the generated code", (Throwable)e);
            }
        }
        if (clazz == String.class) {
            return new String(bytes, RpcConstants.DEFAULT_CHARSET);
        }
        throw new DeserializationException("Unsupported class:" + clazz.getName() + ", only support protobuf message");
    }

    public static Class getReqClass(String service, String methodName, ClassLoader classLoader) throws ClassNotFoundException, CodecException {
        String key;
        Class reqClass;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((reqClass = REQUEST_CLASS_CACHE.get(key = ProtobufSerializer.buildMethodKey(service, methodName))) == null) {
            String interfaceClass = service.contains(":") ? service.substring(0, service.indexOf(58)) : service;
            Class<?> clazz = Class.forName(interfaceClass, true, classLoader);
            ProtobufSerializer.loadProtoClassToCache(key, clazz, methodName);
        }
        return REQUEST_CLASS_CACHE.get(key);
    }

    public static Class getResClass(String service, String methodName, ClassLoader classLoader) throws ClassNotFoundException, CodecException {
        String key;
        Class reqClass;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((reqClass = RESPONSE_CLASS_CACHE.get(key = service + "#" + methodName)) == null) {
            String interfaceClass = service.contains(":") ? service.substring(0, service.indexOf(58)) : service;
            Class<?> clazz = Class.forName(interfaceClass, true, classLoader);
            ProtobufSerializer.loadProtoClassToCache(key, clazz, methodName);
        }
        return RESPONSE_CLASS_CACHE.get(key);
    }

    private static String buildMethodKey(String serviceName, String methodName) {
        return serviceName + "#" + methodName;
    }

    private static void loadProtoClassToCache(String key, Class clazz, String methodName) throws CodecException {
        Method[] methods;
        Method pbMethod = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            pbMethod = method;
            break;
        }
        if (pbMethod == null) {
            throw new CodecException("Cannot found protobuf method: " + clazz.getName() + "." + methodName);
        }
        Class<?>[] parameterTypes = pbMethod.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length != 1 || !MessageLite.class.isAssignableFrom(parameterTypes[0])) {
            throw new CodecException("class based protobuf: " + clazz.getName() + ", only support one protobuf parameter!");
        }
        Class<?> reqClass = parameterTypes[0];
        REQUEST_CLASS_CACHE.put(key, reqClass);
        Class<?> resClass = pbMethod.getReturnType();
        if (resClass == Void.TYPE || !MessageLite.class.isAssignableFrom(resClass)) {
            throw new CodecException("class based protobuf: " + clazz.getName() + ", only support return protobuf message!");
        }
        RESPONSE_CLASS_CACHE.put(key, resClass);
    }
}

