/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.bolt;

import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.ClassNameResolver;
import com.alipay.hessian.NameBlackListFilter;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.remoting.DefaultCustomSerializer;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcProtocol;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.sofa.rpc.codec.anthessian.BlackListFileLoader;
import com.alipay.sofa.rpc.codec.anthessian.GenericMultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.anthessian.GenericSingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.anthessian.MultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.anthessian.SingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.antpb.ProtobufSerializer;
import com.alipay.sofa.rpc.codec.bolt.ContextMapConverter;
import com.alipay.sofa.rpc.codec.bolt.SimpleMapSerializer;
import com.alipay.sofa.rpc.common.ReflectCache;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.request.RequestBase;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class SofaRpcSerialization
extends DefaultCustomSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRpcSerialization.class);
    protected SerializerFactory serializerFactory;
    protected SerializerFactory genericSerializerFactory;
    protected SimpleMapSerializer mapSerializer;

    public SofaRpcSerialization() {
        this.init();
    }

    protected void init() {
        this.mapSerializer = new SimpleMapSerializer();
        if (RpcConfigs.getBooleanValue("multiple.classloader.enable")) {
            this.serializerFactory = new MultipleClassLoaderSofaSerializerFactory();
            this.genericSerializerFactory = new GenericMultipleClassLoaderSofaSerializerFactory();
        } else {
            this.serializerFactory = new SingleClassLoaderSofaSerializerFactory();
            this.genericSerializerFactory = new GenericSingleClassLoaderSofaSerializerFactory();
        }
        if (RpcConfigs.getBooleanValue("serialize.blacklist.enable") && SofaConfigs.getBooleanValue("rpc_tr_serialize_blacklist", true)) {
            ClassNameResolver resolver = new ClassNameResolver();
            resolver.addFilter((ClassNameFilter)new NameBlackListFilter(BlackListFileLoader.SOFA_SERIALIZE_BLACK_LIST, 8192));
            this.serializerFactory.setClassNameResolver(resolver);
            this.genericSerializerFactory.setClassNameResolver(resolver);
        }
    }

    public <Response extends ResponseCommand> boolean serializeHeader(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            Object responseObject = ((RpcResponseCommand)response).getResponseObject();
            if (responseObject instanceof SofaResponse) {
                SofaResponse sofaResponse = (SofaResponse)responseObject;
                if (sofaResponse.isError() || sofaResponse.getAppResponse() instanceof Throwable) {
                    sofaResponse.addResponseProp("sofa_head_response_error", "true");
                }
                response.setHeader(this.mapSerializer.encode(sofaResponse.getResponseProps()));
            }
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeHeader(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object requestObject = requestCommand.getRequestObject();
            String service = this.getTargetServiceName(requestObject);
            if (StringUtils.isNotEmpty(service)) {
                HashMap<String, String> header = new HashMap<String, String>(16);
                header.put("service", service);
                byte serializer = requestCommand.getSerializer();
                if (serializer != 1 && serializer != 2) {
                    this.putRequestMetadataToHeader(requestObject, header);
                }
                requestCommand.setHeader(this.mapSerializer.encode(header));
            }
            return true;
        }
        return false;
    }

    protected void putRequestMetadataToHeader(Object requestObject, Map<String, String> header) {
        if (requestObject instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)requestObject;
            header.put("sofa_head_method_name", requestBase.getMethodName());
            header.put("sofa_head_target_service", requestBase.getTargetServiceUniqueName());
            if (requestBase instanceof SofaRequest) {
                SofaRequest sofaRequest = (SofaRequest)requestBase;
                header.put("sofa_head_target_app", sofaRequest.getTargetAppName());
                Map<String, Object> requestProps = sofaRequest.getRequestProps();
                if (requestProps != null) {
                    ContextMapConverter.flatCopyTo("", requestProps, header);
                }
            }
        }
    }

    protected String getTargetServiceName(Object request) {
        if (request instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)request;
            return requestBase.getTargetServiceUniqueName();
        }
        return null;
    }

    public <Request extends RequestCommand> boolean deserializeHeader(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            if (requestCommand.getRequestHeader() != null) {
                return true;
            }
            byte[] header = requestCommand.getHeader();
            Map<String, String> headerMap = this.mapSerializer.decode(header);
            requestCommand.setRequestHeader(headerMap);
            return true;
        }
        return false;
    }

    public <Response extends ResponseCommand> boolean deserializeHeader(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte[] header = responseCommand.getHeader();
            responseCommand.setResponseHeader(this.mapSerializer.decode(header));
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeContent(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object requestObject = requestCommand.getRequestObject();
            if (requestObject instanceof SofaRequest) {
                byte serializer = requestCommand.getSerializer();
                if (serializer == 1) {
                    try {
                        SofaRequest sofaRequest = (SofaRequest)requestObject;
                        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
                        boolean genericSerialize = this.genericSerializeRequest(invokeContext);
                        if (genericSerialize) {
                            output.setSerializerFactory(this.genericSerializerFactory);
                        } else {
                            output.setSerializerFactory(this.serializerFactory);
                        }
                        output.writeObject((Object)sofaRequest);
                        Object[] args = sofaRequest.getMethodArgs();
                        if (args != null) {
                            for (Object arg : args) {
                                output.writeObject(arg);
                            }
                        }
                        output.close();
                        request.setContent(byteArray.toByteArray());
                        byteArray.close();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException ex) {
                        throw new SerializationException(ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        this.recordSerializeRequest((RequestCommand)requestCommand, invokeContext);
                    }
                }
                if (serializer == 11) {
                    try {
                        SofaRequest sofaRequest = (SofaRequest)requestObject;
                        Object[] args = sofaRequest.getMethodArgs();
                        if (args.length > 1) {
                            throw new SerializationException("Protobuf only support one parameter!");
                        }
                        request.setContent(ProtobufSerializer.getInstance().encode(args[0]));
                        boolean bl = true;
                        return bl;
                    }
                    catch (SerializationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SerializationException(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.recordSerializeRequest((RequestCommand)requestCommand, invokeContext);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void recordSerializeRequest(RequestCommand requestCommand, InvokeContext invokeContext) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_ser_time", cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends RequestCommand> boolean deserializeContent(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object header = requestCommand.getRequestHeader();
            if (!(header instanceof Map)) {
                throw new DeserializationException("Head of request is null or is not map");
            }
            Map headerMap = (Map)header;
            byte serializer = requestCommand.getSerializer();
            if (serializer == 1) {
                byte[] content = requestCommand.getContent();
                if (content == null || content.length == 0) {
                    throw new DeserializationException("Content of request is null");
                }
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(requestCommand.getContent());
                    Hessian2Input hessianInput = new Hessian2Input((InputStream)input);
                    hessianInput.setSerializerFactory(this.serializerFactory);
                    String service = (String)headerMap.get("service");
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader serviceClassLoader = ReflectCache.getServiceClassLoader(service);
                    try {
                        Thread.currentThread().setContextClassLoader(serviceClassLoader);
                        Object object = hessianInput.readObject();
                        if (object instanceof SofaRequest) {
                            SofaRequest sofaRequest = (SofaRequest)object;
                            String[] sig = sofaRequest.getMethodArgSigs();
                            Class[] classSig = new Class[sig.length];
                            this.generateArgTypes(sig, classSig, serviceClassLoader);
                            Object[] args = new Object[sig.length];
                            for (int i = 0; i < sofaRequest.getMethodArgSigs().length; ++i) {
                                args[i] = hessianInput.readObject(classSig[i]);
                            }
                            sofaRequest.setMethodArgs(args);
                        }
                        requestCommand.setRequestObject(object);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                    input.close();
                    hessianInput.close();
                    boolean object = true;
                    return object;
                }
                catch (IOException ex) {
                    throw new DeserializationException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    this.recordDeserializeRequest((RequestCommand)requestCommand);
                }
            }
            if (serializer == 11) {
                try {
                    String service = (String)headerMap.get("service");
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        ClassLoader serviceClassLoader = ReflectCache.getServiceClassLoader(service);
                        Thread.currentThread().setContextClassLoader(serviceClassLoader);
                        SofaRequest sofaRequest = new SofaRequest();
                        sofaRequest.setMethodName((String)headerMap.remove("sofa_head_method_name"));
                        sofaRequest.setTargetAppName((String)headerMap.remove("sofa_head_target_app"));
                        sofaRequest.setTargetServiceUniqueName((String)headerMap.remove("sofa_head_target_service"));
                        HashMap<String, String> traceMap = new HashMap<String, String>(16);
                        ContextMapConverter.treeCopyTo("rpc_trace_context.", headerMap, traceMap, true);
                        sofaRequest.addRequestProp("rpc_trace_context", traceMap);
                        for (Map.Entry entry : headerMap.entrySet()) {
                            sofaRequest.addRequestProp((String)entry.getKey(), entry.getValue());
                        }
                        Class requestClass = ProtobufSerializer.getReqClass(service, sofaRequest.getMethodName(), serviceClassLoader);
                        byte[] content = requestCommand.getContent();
                        if (content == null || content.length == 0) {
                            Constructor constructor = requestClass.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            sofaRequest.setMethodArgs(new Object[]{constructor.newInstance(new Object[0])});
                        } else {
                            Object pbReq = ProtobufSerializer.getInstance().decode(content, requestClass);
                            sofaRequest.setMethodArgs(new Object[]{pbReq});
                        }
                        sofaRequest.setMethodArgSigs(new String[]{requestClass.getName()});
                        requestCommand.setRequestObject((Object)sofaRequest);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (DeserializationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeserializationException(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.recordDeserializeRequest((RequestCommand)requestCommand);
                }
            }
        }
        return false;
    }

    private void recordDeserializeRequest(RequestCommand requestCommand) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_des_time", cost);
    }

    public <Response extends ResponseCommand> boolean serializeContent(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializer = response.getSerializer();
            if (serializer == 1) {
                try {
                    ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                    Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
                    output.setSerializerFactory(this.serializerFactory);
                    output.writeObject(responseCommand.getResponseObject());
                    output.close();
                    response.setContent(byteArray.toByteArray());
                    byteArray.close();
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    throw new SerializationException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    this.recordSerializeResponse(responseCommand);
                }
            }
            if (serializer == 11) {
                try {
                    if (responseCommand.getResponseObject() instanceof SofaResponse) {
                        SofaResponse sofaResponse = (SofaResponse)responseCommand.getResponseObject();
                        if (sofaResponse.isError()) {
                            byte[] content = ProtobufSerializer.getInstance().encode(sofaResponse.getErrorMsg());
                            response.setContent(content);
                        } else {
                            Object appResponse = sofaResponse.getAppResponse();
                            if (appResponse instanceof Throwable) {
                                response.setContent(ProtobufSerializer.getInstance().encode(((Throwable)appResponse).getMessage()));
                            } else {
                                response.setContent(ProtobufSerializer.getInstance().encode(appResponse));
                            }
                        }
                    }
                    boolean sofaResponse = true;
                    return sofaResponse;
                }
                catch (SerializationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SerializationException(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.recordSerializeResponse(responseCommand);
                }
            }
        }
        return false;
    }

    private void recordSerializeResponse(RpcResponseCommand responseCommand) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_ser_time", cost);
    }

    public <Response extends ResponseCommand> boolean deserializeContent(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializer = response.getSerializer();
            if (serializer == 1) {
                byte[] content = responseCommand.getContent();
                if (content == null || content.length == 0) {
                    return false;
                }
                try {
                    Object object;
                    ByteArrayInputStream input = new ByteArrayInputStream(responseCommand.getContent());
                    Hessian2Input hessianInput = new Hessian2Input((InputStream)input);
                    boolean genericSerialize = this.genericSerializeResponse(invokeContext);
                    if (genericSerialize) {
                        hessianInput.setSerializerFactory(this.genericSerializerFactory);
                        GenericObject genericObject = (GenericObject)hessianInput.readObject();
                        SofaResponse sofaResponse = new SofaResponse();
                        sofaResponse.setErrorMsg((String)genericObject.getField("errorMsg"));
                        sofaResponse.setAppResponse(genericObject.getField("appResponse"));
                        object = sofaResponse;
                    } else {
                        hessianInput.setSerializerFactory(this.serializerFactory);
                        object = hessianInput.readObject();
                    }
                    responseCommand.setResponseObject(object);
                    input.close();
                    hessianInput.close();
                    boolean genericObject = true;
                    return genericObject;
                }
                catch (IOException ex) {
                    throw new DeserializationException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    this.recordDeserializeResponse(responseCommand, invokeContext);
                }
            }
            if (serializer == 11) {
                try {
                    String service = (String)invokeContext.get("sofa_head_target_service");
                    String methodName = (String)invokeContext.get("sofa_head_method_name");
                    SofaResponse sofaResponse = new SofaResponse();
                    boolean isError = false;
                    Map header = (Map)responseCommand.getResponseHeader();
                    if (header != null) {
                        if ("true".equals(header.get("sofa_head_response_error"))) {
                            header.remove("sofa_head_response_error");
                            isError = true;
                        }
                        if (!header.isEmpty()) {
                            sofaResponse.setResponseProps(header);
                        }
                    }
                    if (isError) {
                        String errorMessage = (String)ProtobufSerializer.getInstance().decode(responseCommand.getContent(), String.class);
                        sofaResponse.setErrorMsg(errorMessage);
                        responseCommand.setResponseObject((Object)sofaResponse);
                    } else {
                        Class responseClass = ProtobufSerializer.getResClass(service, methodName, Thread.currentThread().getContextClassLoader());
                        byte[] content = responseCommand.getContent();
                        if (content == null || content.length == 0) {
                            Constructor constructor = responseClass.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            sofaResponse.setAppResponse(constructor.newInstance(new Object[0]));
                        } else {
                            Object pbRes = ProtobufSerializer.getInstance().decode(content, responseClass);
                            sofaResponse.setAppResponse(pbRes);
                        }
                        responseCommand.setResponseObject((Object)sofaResponse);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (DeserializationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeserializationException(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.recordDeserializeResponse(responseCommand, invokeContext);
                }
            }
            return false;
        }
        return false;
    }

    private void recordDeserializeResponse(RpcResponseCommand responseCommand, InvokeContext invokeContext) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_des_time", cost);
    }

    protected void generateArgTypes(String[] sig, Class[] classSig, ClassLoader appClassLoader) throws IOException {
        for (int x = 0; x < sig.length; ++x) {
            String name = ClassTypeUtils.canonicalNameToJvmName(sig[x]);
            Class<?> signature = this.getPrimitiveType(name);
            if (signature != null) {
                classSig[x] = signature;
                continue;
            }
            try {
                signature = this.getJdkType(name);
            }
            catch (ClassNotFoundException e1) {
                signature = null;
            }
            if (signature != null) {
                classSig[x] = signature;
            } else {
                try {
                    classSig[x] = Class.forName(name, true, appClassLoader);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(LogCodes.getLog("02415", name), e);
                    throw new IOException(LogCodes.getLog("02415", name));
                }
            }
            if (classSig[x] != null) continue;
            throw new IOException(LogCodes.getLog("02415", sig[x]));
        }
    }

    private Class<?> getPrimitiveType(String name) {
        if (null != name) {
            if ("byte".equals(name)) {
                return Byte.TYPE;
            }
            if ("short".equals(name)) {
                return Short.TYPE;
            }
            if ("int".equals(name)) {
                return Integer.TYPE;
            }
            if ("long".equals(name)) {
                return Long.TYPE;
            }
            if ("char".equals(name)) {
                return Character.TYPE;
            }
            if ("float".equals(name)) {
                return Float.TYPE;
            }
            if ("double".equals(name)) {
                return Double.TYPE;
            }
            if ("boolean".equals(name)) {
                return Boolean.TYPE;
            }
            if ("void".equals(name)) {
                return Void.TYPE;
            }
        }
        return null;
    }

    private Class<?> getJdkType(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.")) {
            return Class.forName(name);
        }
        return null;
    }

    private boolean genericSerializeResponse(InvokeContext invokeContext) {
        Integer serializeType = invokeContext == null ? null : (Integer)invokeContext.get("SerializeFactoryType");
        return serializeType != null && serializeType == 2;
    }

    protected boolean genericSerializeRequest(InvokeContext invokeContext) {
        Integer serializeType = invokeContext == null ? null : (Integer)invokeContext.get("SerializeFactoryType");
        return serializeType != null && serializeType != 0;
    }
}

