/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectCache {
    private static Map<String, ClassLoader> APPNAME_CLASSLOADER_MAP = new ConcurrentHashMap<String, ClassLoader>();
    private static Map<String, ClassLoader> SERVICE_CLASSLOADER_MAP = new ConcurrentHashMap<String, ClassLoader>();
    private static final ConcurrentHashMap<String, Map<String, Method>> METHOD_CACHE = new ConcurrentHashMap();

    public static void registerAppClassLoader(String appName, ClassLoader classloader) {
        APPNAME_CLASSLOADER_MAP.put(appName, classloader);
    }

    public static ClassLoader getAppClassLoader(String appName) {
        ClassLoader appClassLoader = APPNAME_CLASSLOADER_MAP.get(appName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static void registerServiceClassLoader(String serviceUniqueName, ClassLoader classloader) {
        SERVICE_CLASSLOADER_MAP.put(serviceUniqueName, classloader);
    }

    public static ClassLoader getServiceClassLoader(String serviceUniqueName) {
        ClassLoader appClassLoader = SERVICE_CLASSLOADER_MAP.get(serviceUniqueName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static final void putServiceMethodCache(String serviceUniqueName, Class clazz) {
        HashMap<String, Method> publicMethods = new HashMap<String, Method>();
        for (Method m : clazz.getMethods()) {
            StringBuilder mSigs = new StringBuilder();
            mSigs.append(m.getName());
            for (Class<?> paramType : m.getParameterTypes()) {
                mSigs.append(paramType.getName());
            }
            publicMethods.put(mSigs.toString(), m);
        }
        METHOD_CACHE.put(serviceUniqueName, publicMethods);
    }

    public static void invalidateServiceMethodCache(String serviceUniqueName) {
        METHOD_CACHE.remove(serviceUniqueName);
    }

    public static Method getServiceMethod(String serviceUniqueName, String methodName, String[] methodSigns) {
        return ReflectCache.getOrInitServiceMethod(serviceUniqueName, methodName, methodSigns, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getOrInitServiceMethod(String serviceUniqueName, String methodName, String[] methodSigns, boolean init, String interfaceName) {
        Map<String, Method> map = METHOD_CACHE.get(serviceUniqueName);
        if (map == null) {
            if (init) {
                Class<ReflectCache> clazz = ReflectCache.class;
                synchronized (ReflectCache.class) {
                    map = METHOD_CACHE.get(serviceUniqueName);
                    if (map == null) {
                        ReflectCache.putServiceMethodCache(serviceUniqueName, ClassUtils.forName(interfaceName));
                        map = METHOD_CACHE.get(serviceUniqueName);
                    }
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                }
            } else {
                return null;
            }
        }
        {
            StringBuilder methodKeyBuffer = new StringBuilder();
            methodKeyBuffer.append(methodName);
            for (String methodSign : methodSigns) {
                methodKeyBuffer.append(methodSign);
            }
            return map.get(methodKeyBuffer.toString());
        }
    }
}

