/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassTypeUtils {
    private static final Map<String, Class> CLASS_MAP = new ConcurrentHashMap<String, Class>();
    private static final Map<Class, String> TYPE_STR_MAP = new ConcurrentHashMap<Class, String>();

    public static Class[] getClasses(String[] typeStrs) throws RuntimeException {
        if (CommonUtils.isEmpty(typeStrs)) {
            return new Class[0];
        }
        Class[] classes = new Class[typeStrs.length];
        for (int i = 0; i < typeStrs.length; ++i) {
            classes[i] = ClassTypeUtils.getClass(typeStrs[i]);
        }
        return classes;
    }

    public static Class getClass(String typeStr) {
        Class<Void> clazz = CLASS_MAP.get(typeStr);
        if (clazz == null) {
            if ("void".equals(typeStr)) {
                clazz = Void.TYPE;
            } else if ("boolean".equals(typeStr)) {
                clazz = Boolean.TYPE;
            } else if ("byte".equals(typeStr)) {
                clazz = Byte.TYPE;
            } else if ("char".equals(typeStr)) {
                clazz = Character.TYPE;
            } else if ("double".equals(typeStr)) {
                clazz = Double.TYPE;
            } else if ("float".equals(typeStr)) {
                clazz = Float.TYPE;
            } else if ("int".equals(typeStr)) {
                clazz = Integer.TYPE;
            } else if ("long".equals(typeStr)) {
                clazz = Long.TYPE;
            } else if ("short".equals(typeStr)) {
                clazz = Short.TYPE;
            } else {
                String jvmName = ClassTypeUtils.canonicalNameToJvmName(typeStr);
                clazz = ClassUtils.forName(jvmName);
            }
            CLASS_MAP.put(typeStr, clazz);
        }
        return clazz;
    }

    public static String canonicalNameToJvmName(String canonicalName) {
        boolean isArray = canonicalName.endsWith("[]");
        if (isArray) {
            String t = "";
            while (isArray) {
                canonicalName = canonicalName.substring(0, canonicalName.length() - 2);
                t = t + "[";
                isArray = canonicalName.endsWith("[]");
            }
            canonicalName = "boolean".equals(canonicalName) ? t + "Z" : ("byte".equals(canonicalName) ? t + "B" : ("char".equals(canonicalName) ? t + "C" : ("double".equals(canonicalName) ? t + "D" : ("float".equals(canonicalName) ? t + "F" : ("int".equals(canonicalName) ? t + "I" : ("long".equals(canonicalName) ? t + "J" : ("short".equals(canonicalName) ? t + "S" : t + "L" + canonicalName + ";")))))));
        }
        return canonicalName;
    }

    public static String[] getTypeStrs(Class[] types) {
        return ClassTypeUtils.getTypeStrs(types, false);
    }

    public static String[] getTypeStrs(Class[] types, boolean javaStyle) {
        if (CommonUtils.isEmpty(types)) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        String[] strings = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            strings[i] = javaStyle ? types[i].getName() : ClassTypeUtils.getTypeStr(types[i]);
        }
        return strings;
    }

    public static String getTypeStr(Class clazz) {
        String typeStr = TYPE_STR_MAP.get(clazz);
        if (typeStr == null) {
            if (clazz.isArray()) {
                String name = clazz.getName();
                typeStr = ClassTypeUtils.jvmNameToCanonicalName(name);
            } else {
                typeStr = clazz.getName();
            }
            TYPE_STR_MAP.put(clazz, typeStr);
        }
        return typeStr;
    }

    public static String jvmNameToCanonicalName(String jvmName) {
        boolean isArray;
        boolean bl = isArray = jvmName.charAt(0) == '[';
        if (isArray) {
            int i;
            String cnName = "";
            for (i = 0; i < jvmName.length() && jvmName.charAt(i) == '['; ++i) {
                cnName = cnName + "[]";
            }
            String componentType = jvmName.substring(i, jvmName.length());
            cnName = "Z".equals(componentType) ? "boolean" + cnName : ("B".equals(componentType) ? "byte" + cnName : ("C".equals(componentType) ? "char" + cnName : ("D".equals(componentType) ? "double" + cnName : ("F".equals(componentType) ? "float" + cnName : ("I".equals(componentType) ? "int" + cnName : ("J".equals(componentType) ? "long" + cnName : ("S".equals(componentType) ? "short" + cnName : componentType.substring(1, componentType.length() - 1) + cnName)))))));
            return cnName;
        }
        return jvmName;
    }
}

