/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtils {
    private static final ConcurrentHashMap<String, Method> METHOD_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Class[]> METHOD_ARGS_TYPE_CACHE = new ConcurrentHashMap();

    public static boolean isPrimitives(Class<?> clazz) {
        if (clazz.isArray()) {
            return ReflectUtils.isPrimitiveType(clazz.getComponentType());
        }
        return ReflectUtils.isPrimitiveType(clazz);
    }

    private static boolean isPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive() || Boolean.class == clazz || Character.class == clazz || Number.class.isAssignableFrom(clazz) || String.class == clazz || Date.class.isAssignableFrom(clazz);
    }

    public static String getCodeBase(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ProtectionDomain domain = cls.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        if (location == null) {
            return null;
        }
        return location.getFile();
    }

    public static Method getMethod(String clazzName, String methodName, String[] argsType) throws ClassNotFoundException, NoSuchMethodException {
        Class[] classes;
        Class clazz;
        Method old;
        StringBuilder sb = new StringBuilder(256);
        sb.append(clazzName).append("#").append(methodName).append("(");
        if (argsType != null && argsType.length > 0) {
            for (String argType : argsType) {
                sb.append(argType).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        String key = sb.toString();
        Method method = METHOD_CACHE.get(key);
        if (method == null && (old = METHOD_CACHE.putIfAbsent(key, method = (clazz = ClassUtils.forName(clazzName)).getMethod(methodName, classes = ClassTypeUtils.getClasses(argsType)))) != null) {
            method = old;
        }
        return method;
    }

    public static Method getMethod(Class clazz, String methodName, String[] argsType) throws NoSuchMethodException, ClassNotFoundException {
        return ReflectUtils.getMethod(clazz.getCanonicalName(), methodName, argsType);
    }

    public static void cacheMethodArgsType(String interfaceId, String methodName, Class[] argsType) {
        String key = interfaceId + "#" + methodName;
        METHOD_ARGS_TYPE_CACHE.put(key, argsType);
    }

    public static Class[] getMethodArgsType(String interfaceId, String methodName) {
        String key = interfaceId + "#" + methodName;
        return METHOD_ARGS_TYPE_CACHE.get(key);
    }

    public static Method getPropertySetterMethod(Class clazz, String property, Class propertyClazz) throws NoSuchMethodException {
        String methodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = clazz.getMethod(methodName, propertyClazz);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("No setter method for " + clazz.getName() + "#" + property);
        }
    }

    public static Method getPropertyGetterMethod(Class clazz, String property) throws NoSuchMethodException {
        Method method;
        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                methodName = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
                method = clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new NoSuchMethodException("No getter method for " + clazz.getName() + "#" + property);
            }
        }
        return method;
    }

    protected static boolean isBeanPropertyReadMethod(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.TYPE && method.getDeclaringClass() != Object.class && method.getParameterTypes().length == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is")) && !"get".equals(method.getName()) && !"is".equals(method.getName());
    }

    protected static String getPropertyNameFromBeanReadMethod(Method method) {
        if (ReflectUtils.isBeanPropertyReadMethod(method)) {
            if (method.getName().startsWith("get")) {
                return method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
            }
            if (method.getName().startsWith("is")) {
                return method.getName().substring(2, 3).toLowerCase() + method.getName().substring(3);
            }
        }
        return null;
    }

    protected static boolean isBeanPropertyWriteMethod(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass() != Object.class && method.getParameterTypes().length == 1 && method.getName().startsWith("set") && !"set".equals(method.getName());
    }

    protected static boolean isPublicInstanceField(Field field) {
        return Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && !field.isSynthetic();
    }
}

