/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;

public class ConfigUniqueNameGenerator {
    public static String getUniqueName(AbstractInterfaceConfig interfaceConfig) {
        String uniqueId = interfaceConfig.getUniqueId();
        return interfaceConfig.getInterfaceId() + ":" + interfaceConfig.getVersion() + (StringUtils.isEmpty(uniqueId) ? "" : ":" + uniqueId);
    }

    public static String getUniqueNameProtocol(ProviderConfig providerConfig, String protocol) {
        if (StringUtils.isNotEmpty(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(providerConfig) + "@" + protocol;
        }
        return ConfigUniqueNameGenerator.getUniqueName(providerConfig);
    }

    public static String getUniqueNameProtocol(ConsumerConfig consumerConfig) {
        return ConfigUniqueNameGenerator.getUniqueName(consumerConfig) + "@" + consumerConfig.getProtocol();
    }
}

