/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.context;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.module.ModuleFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.rpc.server.ServerFactory;
import com.alipay.sofa.rpc.transport.ClientTransportFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RpcRuntimeContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcRuntimeContext.class);
    private static final ConcurrentHashMap CONTEXT = new ConcurrentHashMap();
    public static final String PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    public static final long START_TIME = RpcRuntimeContext.now();
    private static final ConcurrentHashSet<ProviderBootstrap> EXPORTED_PROVIDER_CONFIGS = new ConcurrentHashSet();
    private static final ConcurrentHashSet<ConsumerBootstrap> REFERRED_CONSUMER_CONFIGS = new ConcurrentHashSet();
    private static final List<Destroyable.DestroyHook> DESTROY_HOOKS = new CopyOnWriteArrayList<Destroyable.DestroyHook>();
    public static final String KEY_APPAPTH = "appPath";
    public static final String APP_ID = "sofa.app.id";
    public static final String APP_NAME = "sofa.app.name";
    public static final String INSTANCE_ID = "sofa.instance.id";
    public static final String KEY_APPID = "appId";
    public static final String KEY_APPNAME = "appName";
    public static final String KEY_APPINSID = "appInsId";
    public static final ConcurrentMap<String, Map<String, String>> INTERFACE_CONFIGS;

    private static void initContext() {
        RpcRuntimeContext.putIfAbsent(KEY_APPID, RpcConfigs.getOrDefaultValue(APP_ID, null));
        RpcRuntimeContext.putIfAbsent(KEY_APPNAME, RpcConfigs.getOrDefaultValue(APP_NAME, null));
        RpcRuntimeContext.putIfAbsent(KEY_APPINSID, RpcConfigs.getOrDefaultValue(INSTANCE_ID, null));
    }

    public static void destroy() {
        RpcRuntimeContext.destroy(true);
    }

    private static void destroy(boolean active) {
        RpcRunningState.setShuttingDown(true);
        for (Destroyable.DestroyHook destroyHook : DESTROY_HOOKS) {
            destroyHook.preDestroy();
        }
        ArrayList<ProviderConfig> providerConfigs = new ArrayList<ProviderConfig>();
        for (ProviderBootstrap bootstrap : EXPORTED_PROVIDER_CONFIGS) {
            providerConfigs.add(bootstrap.getProviderConfig());
        }
        List<Registry> registries = RegistryFactory.getRegistries();
        if (CommonUtils.isNotEmpty(registries) && CommonUtils.isNotEmpty(providerConfigs)) {
            for (Registry registry : registries) {
                registry.batchUnRegister(providerConfigs);
            }
        }
        ServerFactory.destroyAll();
        for (ProviderBootstrap providerBootstrap : EXPORTED_PROVIDER_CONFIGS) {
            providerBootstrap.unExport();
        }
        for (ConsumerBootstrap consumerBootstrap : REFERRED_CONSUMER_CONFIGS) {
            ConsumerConfig config = consumerBootstrap.getConsumerConfig();
            if (CommonUtils.isFalse(config.getParameter(".destroy"))) continue;
            consumerBootstrap.unRefer();
        }
        RegistryFactory.destroyAll();
        ClientTransportFactory.closeAll();
        if (!RpcRunningState.isUnitTestMode()) {
            ModuleFactory.uninstallModules();
        }
        for (Destroyable.DestroyHook destroyHook : DESTROY_HOOKS) {
            destroyHook.postDestroy();
        }
        RpcRunningState.setShuttingDown(false);
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("SOFA RPC Framework has been release all resources {}...", active ? "actively " : "");
        }
    }

    public static void registryDestroyHook(Destroyable.DestroyHook destroyHook) {
        DESTROY_HOOKS.add(destroyHook);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static void cacheConsumerConfig(ConsumerBootstrap consumerConfig) {
        REFERRED_CONSUMER_CONFIGS.add(consumerConfig);
    }

    public static void invalidateConsumerConfig(ConsumerBootstrap consumerConfig) {
        REFERRED_CONSUMER_CONFIGS.remove(consumerConfig);
    }

    public static void cacheProviderConfig(ProviderBootstrap providerConfig) {
        EXPORTED_PROVIDER_CONFIGS.add(providerConfig);
    }

    public static void invalidateProviderConfig(ProviderBootstrap providerConfig) {
        EXPORTED_PROVIDER_CONFIGS.remove(providerConfig);
    }

    public static List<ProviderBootstrap> getProviderConfigs() {
        return new ArrayList<ProviderBootstrap>(EXPORTED_PROVIDER_CONFIGS);
    }

    public static List<ConsumerBootstrap> getConsumerConfigs() {
        return new ArrayList<ConsumerBootstrap>(REFERRED_CONSUMER_CONFIGS);
    }

    public static Object get(String key) {
        return CONTEXT.get(key);
    }

    public static Object putIfAbsent(String key, Object value) {
        return value == null ? CONTEXT.remove(key) : CONTEXT.putIfAbsent(key, value);
    }

    public static Object put(String key, Object value) {
        return value == null ? CONTEXT.remove(key) : CONTEXT.put(key, value);
    }

    public static ConcurrentHashMap getContext() {
        return new ConcurrentHashMap(CONTEXT);
    }

    public static String getGlobalVal(String key, String defaultVal) {
        return RpcRuntimeContext.getInterfaceVal("global_setting", key, defaultVal);
    }

    public static void putGlobalVal(String key, String value) {
        RpcRuntimeContext.putInterfaceVal("global_setting", key, value);
    }

    public static String getInterfaceVal(String interfaceId, String key, String defaultVal) {
        String val;
        Map map = (Map)INTERFACE_CONFIGS.get(interfaceId);
        if (map == null) {
            map = CommonUtils.putToConcurrentMap(INTERFACE_CONFIGS, interfaceId, new ConcurrentHashMap());
        }
        return (val = (String)map.get(key)) == null ? defaultVal : val;
    }

    public static void putInterfaceVal(String interfaceId, String key, String value) {
        if (value != null) {
            Map map = (Map)INTERFACE_CONFIGS.get(interfaceId);
            if (map == null) {
                map = CommonUtils.putToConcurrentMap(INTERFACE_CONFIGS, interfaceId, new ConcurrentHashMap());
            }
            map.put(key, value);
        }
    }

    public static Map<String, Map<String, String>> getConfigMaps() {
        return Collections.unmodifiableMap(INTERFACE_CONFIGS);
    }

    public static Map<String, String> getConfigMap(String interfaceId) {
        return (Map)INTERFACE_CONFIGS.get(interfaceId);
    }

    public static void unload(String appName) {
    }

    static {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Welcome! Loading SOFA RPC Framework : {}, PID is:{}", "5.3.1_20180419005237", PID);
        }
        RpcRuntimeContext.put("rpcVer", 50301);
        RpcRuntimeContext.initContext();
        ModuleFactory.installModules();
        if (RpcConfigs.getOrDefaultValue("jvm.shutdown.hook", true).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("SOFA RPC Framework catch JVM shutdown event, Run shutdown hook now.");
                    }
                    RpcRuntimeContext.destroy(false);
                }
            }, "SOFA-RPC-ShutdownHook"));
        }
        INTERFACE_CONFIGS = new ConcurrentHashMap<String, Map<String, String>>();
    }
}

