/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.api.GenericContext;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;

@Extension(value="consumerGeneric", order=-18000)
@AutoActive(consumerSide=true)
public class ConsumerGenericFilter
extends Filter {
    private static final String METHOD_INVOKE = "$invoke";
    private static final String METHOD_GENERIC_INVOKE = "$genericInvoke";

    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        ConsumerConfig consumerConfig = (ConsumerConfig)invoker.getConfig();
        return consumerConfig.isGeneric();
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        try {
            int type = this.getSerializeFactoryType(request.getMethodName(), request.getMethodArgs());
            request.setSerializeFactoryType(type);
            Object[] genericArgs = request.getMethodArgs();
            String methodName = (String)genericArgs[0];
            String[] argTypes = (String[])genericArgs[1];
            Object[] args = (Object[])genericArgs[2];
            request.setMethodName(methodName);
            request.setMethodArgSigs(argTypes);
            request.setMethodArgs(args);
            ConsumerConfig consumerConfig = (ConsumerConfig)invoker.getConfig();
            String invokeType = consumerConfig.getMethodInvokeType(methodName);
            request.setInvokeType(invokeType);
            request.addRequestProp("type", invokeType);
            return invoker.invoke(request);
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcException(270, e.getMessage(), e);
        }
    }

    private int getSerializeFactoryType(String method, Object[] args) throws SofaRpcException {
        if (METHOD_INVOKE.equals(method)) {
            return 0;
        }
        if (METHOD_GENERIC_INVOKE.equals(method)) {
            if (args.length == 3) {
                return 2;
            }
            if (args.length == 4) {
                if (args[3] instanceof GenericContext) {
                    return 2;
                }
                if (args[3] instanceof Class) {
                    return 1;
                }
            } else if (args.length == 5) {
                return 1;
            }
        }
        throw new SofaRpcException(270, "Unsupported method of generic service");
    }
}

