/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.api.context.RpcReferenceContext;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import java.net.InetSocketAddress;

@Extension(value="referenceContext", order=-19500)
@AutoActive(consumerSide=true)
public class RpcReferenceContextFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return RpcInternalContext.isAttachmentEnable();
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        Integer ps;
        Integer qs;
        Long ct;
        ConsumerConfig config = (ConsumerConfig)invoker.getConfig();
        RpcReferenceContext referenceCtx = new RpcReferenceContext();
        referenceCtx.setGeneric(config.isGeneric());
        referenceCtx.setInterfaceName(config.getInterfaceId());
        referenceCtx.setUniqueId(config.getUniqueId());
        referenceCtx.setServiceName(request.getTargetServiceUniqueName());
        referenceCtx.setMethodName(request.getMethodName());
        RpcInternalContext context = RpcInternalContext.getContext();
        ProviderInfo providerInfo = context.getProviderInfo();
        if (providerInfo != null) {
            referenceCtx.setTargetAppName(providerInfo.getStaticAttr("appName"));
            referenceCtx.setTargetUrl(providerInfo.getHost() + ":" + providerInfo.getPort());
        }
        referenceCtx.setProtocol(config.getProtocol());
        referenceCtx.setInvokeType(request.getInvokeType());
        referenceCtx.setRouteRecord((String)context.getAttachment("_router_record"));
        RpcInvokeContext.getContext().put("rpc.reference.ctx", referenceCtx);
        SofaResponse response = invoker.invoke(request);
        InetSocketAddress local = context.getLocalAddress();
        if (local != null) {
            referenceCtx.setClinetIP(NetUtils.toIpString(local));
            referenceCtx.setClientPort(local.getPort());
        }
        if ((ct = (Long)context.getAttachment("_conn_create_time")) != null) {
            referenceCtx.setConnEstablishedSpan(ct);
        }
        if ((qs = (Integer)context.getAttachment("_req_size")) != null) {
            referenceCtx.setRequestSize(qs.longValue());
        }
        if ((ps = (Integer)context.getAttachment("_resp_size")) != null) {
            referenceCtx.setResponseSize(ps.longValue());
        }
        referenceCtx.setTraceId((String)context.getAttachment("_trace_id"));
        referenceCtx.setRpcId((String)context.getAttachment("_span_id"));
        Long ce = (Long)context.getAttachment("_client_elapse");
        if (ce != null) {
            referenceCtx.setCostTime(ce);
        }
        return response;
    }
}

