/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.bolt;

import com.alipay.remoting.InvokeCallback;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.filter.FilterChain;
import com.alipay.sofa.rpc.message.bolt.BoltResponseFuture;
import java.util.concurrent.Executor;

public class BoltFutureInvokeCallback
implements InvokeCallback {
    protected final ConsumerConfig consumerConfig;
    protected final ProviderInfo providerInfo;
    public BoltResponseFuture rpcFuture;
    protected final SofaRequest request;
    protected ClassLoader classLoader;
    protected RpcInternalContext context;

    public BoltFutureInvokeCallback(ConsumerConfig consumerConfig, ProviderInfo providerInfo, BoltResponseFuture rpcFuture, SofaRequest request, RpcInternalContext context, ClassLoader classLoader) {
        this.consumerConfig = consumerConfig;
        this.providerInfo = providerInfo;
        this.rpcFuture = rpcFuture;
        this.request = request;
        this.context = context;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Object result) {
        if (this.rpcFuture == null) {
            return;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        SofaResponse response = (SofaResponse)result;
        Throwable throwable = null;
        RpcInvokeContext invokeCtx = null;
        try {
            FilterChain chain;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            RpcInternalContext.setContext(this.context);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, this.request, response, null));
            }
            if (RpcInvokeContext.isBaggageEnable()) {
                if (this.context != null) {
                    invokeCtx = (RpcInvokeContext)this.context.getAttachment(".invoke_ctx");
                }
                if (invokeCtx == null) {
                    invokeCtx = RpcInvokeContext.getContext();
                } else {
                    RpcInvokeContext.setContext(invokeCtx);
                }
                BaggageResolver.pickupFromResponse(invokeCtx, response);
            }
            if ((chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain()) != null) {
                chain.onAsyncResponse(this.consumerConfig, this.request, response, null);
            }
            Object appResp = response.getAppResponse();
            if (response.isError()) {
                SofaRpcException sofaRpcException = new SofaRpcException(199, response.getErrorMsg());
                this.rpcFuture.setFailure(sofaRpcException);
            } else if (appResp instanceof Throwable) {
                throwable = (Throwable)appResp;
                this.rpcFuture.setFailure(throwable);
            } else {
                this.rpcFuture.setSuccess(appResp);
            }
        }
        finally {
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(this.request, response, null));
            }
            Thread.currentThread().setContextClassLoader(oldCl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable e) {
        if (this.rpcFuture == null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            FilterChain chain;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            RpcInternalContext.setContext(this.context);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, this.request, null, e));
            }
            if ((chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain()) != null) {
                chain.onAsyncResponse(this.consumerConfig, this.request, null, e);
            }
            this.rpcFuture.setFailure(e);
        }
        finally {
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(this.request, null, e));
            }
            Thread.currentThread().setContextClassLoader(cl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }

    public Executor getExecutor() {
        return AsyncRuntime.getAsyncThreadPool();
    }
}

