/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.bolt;

import com.alipay.remoting.AsyncContext;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.invoke.SendableResponseCallback;
import com.alipay.sofa.rpc.core.request.RequestBase;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerSendEvent;

public abstract class BoltSendableResponseCallback<T>
implements SendableResponseCallback<T> {
    protected AsyncContext asyncContext;
    protected SofaRequest request;
    private boolean sent;

    public BoltSendableResponseCallback() {
        this.init();
    }

    protected void init() {
        RpcInternalContext context = RpcInternalContext.getContext();
        this.asyncContext = (AsyncContext)context.getAttachment(".async_context");
        this.request = (SofaRequest)context.getAttachment(".async_req");
    }

    @Override
    public void onAppException(Throwable throwable, String methodName, RequestBase request) {
        this.sendAppException(throwable);
    }

    @Override
    public void onSofaException(SofaRpcException sofaException, String methodName, RequestBase request) {
        this.sendSofaException(sofaException);
    }

    @Override
    public void sendAppResponse(Object appResponse) {
        this.checkState();
        SofaResponse response = new SofaResponse();
        response.setAppResponse(appResponse);
        this.sendSofaResponse(response, null);
    }

    @Override
    public void sendAppException(Throwable throwable) {
        this.checkState();
        SofaResponse response = new SofaResponse();
        response.setAppResponse(throwable);
        this.sendSofaResponse(response, null);
    }

    @Override
    public void sendSofaException(SofaRpcException sofaException) {
        this.checkState();
        this.checkState();
        SofaResponse response = new SofaResponse();
        response.setErrorMsg(sofaException.getMessage());
        this.sendSofaResponse(response, sofaException);
    }

    protected void checkState() {
        if (this.sent) {
            throw new IllegalStateException("AsyncProxyResponseCallback has been sent response");
        }
        this.sent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSofaResponse(SofaResponse response, SofaRpcException sofaException) {
        try {
            if (RpcInvokeContext.isBaggageEnable()) {
                BaggageResolver.carryWithResponse(RpcInvokeContext.peekContext(), response);
            }
            this.asyncContext.sendResponse((Object)response);
        }
        finally {
            if (EventBus.isEnable(ServerSendEvent.class)) {
                EventBus.post(new ServerSendEvent(this.request, response, sofaException));
            }
        }
    }
}

