/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.proxy.jdk;

import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.message.MessageBuilder;
import com.alipay.sofa.rpc.proxy.jdk.JDKProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class JDKInvocationHandler
implements InvocationHandler {
    private Class proxyClass;
    private Invoker proxyInvoker;

    public JDKInvocationHandler(Class proxyClass, Invoker proxyInvoker) {
        this.proxyClass = proxyClass;
        this.proxyInvoker = proxyInvoker;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] paramValues) throws Throwable {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if ("toString".equals(methodName) && paramTypes.length == 0) {
            return this.proxyInvoker.toString();
        }
        if ("hashCode".equals(methodName) && paramTypes.length == 0) {
            return this.proxyInvoker.hashCode();
        }
        if ("equals".equals(methodName) && paramTypes.length == 1) {
            Object another = paramValues[0];
            return proxy == another || proxy.getClass().isInstance(another) && this.proxyInvoker.equals(JDKProxy.parseInvoker(another));
        }
        SofaRequest sofaRequest = MessageBuilder.buildSofaRequest(method.getDeclaringClass(), method, paramTypes, paramValues);
        SofaResponse response = this.proxyInvoker.invoke(sofaRequest);
        if (response.isError()) {
            throw new SofaRpcException(199, response.getErrorMsg());
        }
        Object ret = response.getAppResponse();
        if (ret instanceof Throwable) {
            throw (Throwable)ret;
        }
        return ret;
    }

    public Class getProxyClass() {
        return this.proxyClass;
    }

    public Invoker getProxyInvoker() {
        return this.proxyInvoker;
    }
}

