/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperRegistryHelper {
    static List<String> convertProviderToUrls(ProviderConfig providerConfig) {
        List<ServerConfig> servers = providerConfig.getServer();
        if (servers != null && !servers.isEmpty()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ServerConfig server : servers) {
                StringBuilder sb = new StringBuilder(200);
                String host = server.getVirtualHost();
                if (host == null && (NetUtils.isLocalHost(host = server.getHost()) || NetUtils.isAnyHost(host))) {
                    host = SystemInfo.getLocalHost();
                }
                sb.append(server.getProtocol()).append("://").append(host).append(":").append(server.getPort()).append(server.getContextPath()).append("?uniqueId=").append(providerConfig.getUniqueId()).append(ZookeeperRegistryHelper.getKeyPairs("version", "1.0")).append(ZookeeperRegistryHelper.getKeyPairs("timeout", providerConfig.getTimeout())).append(ZookeeperRegistryHelper.getKeyPairs("delay", providerConfig.getDelay())).append(ZookeeperRegistryHelper.getKeyPairs("id", providerConfig.getId())).append(ZookeeperRegistryHelper.getKeyPairs("dynamic", providerConfig.isDynamic())).append(ZookeeperRegistryHelper.getKeyPairs("weight", providerConfig.getWeight())).append(ZookeeperRegistryHelper.getKeyPairs("crossLang", providerConfig.getParameter("crossLang"))).append(ZookeeperRegistryHelper.getKeyPairs("accepts", server.getAccepts())).append(ZookeeperRegistryHelper.getKeyPairs("startTime", RpcRuntimeContext.START_TIME)).append(ZookeeperRegistryHelper.getKeyPairs("appName", providerConfig.getAppName()));
                ZookeeperRegistryHelper.addCommonAttrs(sb);
                urls.add(sb.toString());
            }
            return urls;
        }
        return null;
    }

    static String convertConsumerToUrl(ConsumerConfig consumerConfig) {
        StringBuilder sb = new StringBuilder(200);
        String host = SystemInfo.getLocalHost();
        sb.append(consumerConfig.getProtocol()).append("://").append(host).append("/").append(consumerConfig.getInterfaceId()).append("?uniqueId=").append(consumerConfig.getUniqueId()).append(ZookeeperRegistryHelper.getKeyPairs("version", "1.0")).append(ZookeeperRegistryHelper.getKeyPairs("pid", RpcRuntimeContext.PID)).append(ZookeeperRegistryHelper.getKeyPairs("timeout", consumerConfig.getTimeout())).append(ZookeeperRegistryHelper.getKeyPairs("id", consumerConfig.getId())).append(ZookeeperRegistryHelper.getKeyPairs("crossLang", consumerConfig.getParameter("crossLang"))).append(ZookeeperRegistryHelper.getKeyPairs("generic", consumerConfig.isGeneric())).append(ZookeeperRegistryHelper.getKeyPairs("appName", consumerConfig.getAppName())).append(ZookeeperRegistryHelper.getKeyPairs("serialization", consumerConfig.getSerialization())).append(ZookeeperRegistryHelper.getKeyPairs("startTime", RpcRuntimeContext.START_TIME));
        ZookeeperRegistryHelper.addCommonAttrs(sb);
        return sb.toString();
    }

    private static String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }

    private static void addCommonAttrs(StringBuilder sb) {
        sb.append(ZookeeperRegistryHelper.getKeyPairs("pid", RpcRuntimeContext.PID));
        sb.append(ZookeeperRegistryHelper.getKeyPairs("language", "java"));
        sb.append(ZookeeperRegistryHelper.getKeyPairs("appPath", RpcRuntimeContext.get("appPath")));
        sb.append(ZookeeperRegistryHelper.getKeyPairs("rpcVer", "50301"));
        if (RpcRuntimeContext.get("reg.backfile") != null || RpcRuntimeContext.get("provider.backfile") != null) {
            sb.append(ZookeeperRegistryHelper.getKeyPairs("backfile", "false"));
        }
    }

    static List<ProviderInfo> convertUrlsToProviders(String providerPath, List<ChildData> currentData) throws UnsupportedEncodingException {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        if (CommonUtils.isEmpty(currentData)) {
            return providerInfos;
        }
        for (ChildData childData : currentData) {
            String url = childData.getPath().substring(providerPath.length() + 1);
            url = URLDecoder.decode(url, "UTF-8");
            providerInfos.add(ProviderInfo.valueOf(url));
        }
        return providerInfos;
    }

    static ProviderInfo convertUrlToProvider(String providerPath, ChildData childData) throws UnsupportedEncodingException {
        String url = childData.getPath().substring(providerPath.length() + 1);
        url = URLDecoder.decode(url, "UTF-8");
        return ProviderInfo.valueOf(url);
    }

    static String buildProviderPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/providers";
    }

    static String buildConsumerPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/consumers";
    }

    static String buildConfigPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/configs";
    }

    static List<ProviderInfo> matchProviderInfos(ConsumerConfig consumerConfig, List<ProviderInfo> providerInfos) {
        String protocol = consumerConfig.getProtocol();
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        for (ProviderInfo providerInfo : providerInfos) {
            if (!providerInfo.getProtocolType().equalsIgnoreCase(protocol) || !StringUtils.equals(consumerConfig.getUniqueId(), providerInfo.getAttr("uniqueId"))) continue;
            result.add(providerInfo);
        }
        return result;
    }
}

