/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.bolt;

import com.alipay.remoting.RemotingServer;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.ReflectCache;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.BusinessPool;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.bolt.BoltServerProcessor;
import com.alipay.sofa.rpc.server.bolt.SofaRejectedExecutionHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="bolt")
public class BoltServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltServer.class);
    protected volatile boolean started;
    protected RemotingServer remotingServer;
    protected ServerConfig serverConfig;
    BoltServerProcessor boltServerProcessor;
    protected ThreadPoolExecutor bizThreadPool;
    protected Map<String, Invoker> invokerMap = new ConcurrentHashMap<String, Invoker>();

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.bizThreadPool = this.initThreadPool(serverConfig);
        this.boltServerProcessor = new BoltServerProcessor(this);
    }

    protected ThreadPoolExecutor initThreadPool(ServerConfig serverConfig) {
        ThreadPoolExecutor threadPool = BusinessPool.initPool(serverConfig);
        threadPool.setThreadFactory(new NamedThreadFactory("SofaBizProcessor-" + serverConfig.getPort(), serverConfig.isDaemon()));
        threadPool.setRejectedExecutionHandler(new SofaRejectedExecutionHandler());
        if (serverConfig.isPreStartCore()) {
            threadPool.prestartAllCoreThreads();
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        BoltServer boltServer = this;
        synchronized (boltServer) {
            if (this.started) {
                return;
            }
            this.remotingServer = this.initRemotingServer();
            try {
                if (!this.remotingServer.start(this.serverConfig.getBoundHost())) {
                    throw new SofaRpcRuntimeException("Failed to start bolt server, see more detail from bolt log.");
                }
                this.started = true;
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to start bolt server!", e);
            }
        }
    }

    protected RemotingServer initRemotingServer() {
        RpcServer remotingServer = new RpcServer(this.serverConfig.getPort());
        remotingServer.registerUserProcessor((UserProcessor)this.boltServerProcessor);
        return remotingServer;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return this.invokerMap.isEmpty();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.remotingServer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.remotingServer = null;
        this.started = false;
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        String key = ConfigUniqueNameGenerator.getUniqueName(providerConfig);
        this.invokerMap.put(key, instance);
        ReflectCache.putServiceMethodCache(key, providerConfig.getProxyClass());
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        String key = ConfigUniqueNameGenerator.getUniqueName(providerConfig);
        this.invokerMap.remove(key);
        ReflectCache.invalidateServiceMethodCache(key);
        if (closeIfNoEntry && this.invokerMap.size() == 0) {
            this.stop();
        }
    }

    @Override
    public void destroy() {
        AtomicInteger count;
        if (!this.started) {
            return;
        }
        int stopTimeout = this.serverConfig.getStopTimeout();
        if (stopTimeout > 0 && ((count = this.boltServerProcessor.processingCount).get() > 0 || this.bizThreadPool.getQueue().size() > 0)) {
            long start = RpcRuntimeContext.now();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There are {} call in processing and {} call in queue, wait {} ms to end", count, this.bizThreadPool.getQueue().size(), stopTimeout);
            }
            while ((count.get() > 0 || this.bizThreadPool.getQueue().size() > 0) && RpcRuntimeContext.now() - start < (long)stopTimeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.bizThreadPool.shutdown();
        this.stop();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        hook.preDestroy();
        this.destroy();
        hook.postDestroy();
    }

    public ThreadPoolExecutor getBizThreadPool() {
        return this.bizThreadPool;
    }

    public Invoker findInvoker(String serviceName) {
        return this.invokerMap.get(serviceName);
    }
}

