/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.rest;

import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.RestServerReceiveEvent;
import com.alipay.sofa.rpc.event.RestServerSendEvent;
import com.alipay.sofa.rpc.event.ServerEndHandleEvent;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class SofaRestRequestHandler
extends SimpleChannelInboundHandler {
    protected final RequestDispatcher dispatcher;
    private static final Logger logger = Logger.getLogger(SofaRestRequestHandler.class);

    public SofaRestRequestHandler(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof NettyHttpRequest) {
            NettyHttpRequest request = (NettyHttpRequest)msg;
            try {
                if (EventBus.isEnable(RestServerReceiveEvent.class)) {
                    EventBus.post(new RestServerReceiveEvent(request));
                }
                if (request.getUri().getPath().endsWith("/favicon.ico")) {
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                    ctx.writeAndFlush((Object)response);
                    if (EventBus.isEnable(RestServerSendEvent.class)) {
                        EventBus.post(new RestServerSendEvent(request, null, null));
                    }
                    return;
                }
                if (request.is100ContinueExpected()) {
                    this.send100Continue(ctx);
                }
                NettyHttpResponse response = request.getResponse();
                Throwable exception = null;
                try {
                    HttpHeaders httpHeaders = request.getHttpHeaders();
                    String remoteip = httpHeaders.getHeaderString("X-Forwarded-For");
                    if (remoteip == null) {
                        remoteip = httpHeaders.getHeaderString("X-Real-IP");
                    }
                    if (remoteip != null) {
                        RpcInternalContext.getContext().setRemoteAddress(remoteip, 0);
                    } else {
                        RpcInternalContext.getContext().setRemoteAddress((InetSocketAddress)ctx.channel().remoteAddress());
                    }
                    RpcInternalContext.getContext().setLocalAddress((InetSocketAddress)ctx.channel().localAddress());
                    this.dispatcher.service(ctx, (HttpRequest)request, (HttpResponse)response, true);
                }
                catch (Failure e1) {
                    response.reset();
                    response.setStatus(e1.getErrorCode());
                    exception = e1;
                }
                catch (Exception ex) {
                    response.reset();
                    response.setStatus(500);
                    logger.error("Unexpected", (Throwable)ex);
                    exception = ex;
                }
                finally {
                    if (EventBus.isEnable(RestServerSendEvent.class)) {
                        EventBus.post(new RestServerSendEvent(request, response, exception));
                    }
                }
                if (!request.getAsyncContext().isSuspended()) {
                    response.finish();
                    ctx.flush();
                }
            }
            finally {
                if (EventBus.isEnable(ServerEndHandleEvent.class)) {
                    EventBus.post(new ServerEndHandleEvent());
                }
                RpcInvokeContext.removeContext();
                RpcInternalContext.removeAllContext();
            }
        }
    }

    private void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            if (ctx.channel().isActive()) {
                logger.warn("Exception caught by request handler", e);
            }
            ctx.close();
        }
    }
}

