/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.ClientTransportHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ReusableClientTransportHolder
implements ClientTransportHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReusableClientTransportHolder.class);
    private final ConcurrentHashMap<String, ClientTransport> clientTransportMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<ClientTransport, AtomicInteger> transportRefCounter = new ConcurrentHashMap();

    @Override
    public ClientTransport getClientTransport(ClientTransportConfig config) {
        AtomicInteger oldCounter;
        AtomicInteger counter;
        ClientTransport oldTransport;
        String key = ReusableClientTransportHolder.getAddr(config);
        ClientTransport transport = this.clientTransportMap.get(key);
        if (transport == null && (oldTransport = this.clientTransportMap.putIfAbsent(key, transport = ExtensionLoaderFactory.getExtensionLoader(ClientTransport.class).getExtension(config.getContainer(), new Class[]{ClientTransportConfig.class}, new Object[]{config}))) != null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Multiple threads init ClientTransport with same key:" + key);
            }
            transport.destroy();
            transport = oldTransport;
        }
        if ((counter = this.transportRefCounter.get(transport)) == null && (oldCounter = this.transportRefCounter.putIfAbsent(transport, counter = new AtomicInteger(0))) != null) {
            counter = oldCounter;
        }
        counter.incrementAndGet();
        return transport;
    }

    private static String getAddr(ClientTransportConfig config) {
        ProviderInfo providerInfo = config.getProviderInfo();
        return providerInfo.getProtocolType() + "://" + providerInfo.getHost() + ":" + providerInfo.getPort();
    }

    @Override
    public boolean removeClientTransport(ClientTransport clientTransport) {
        boolean needDestroy;
        if (clientTransport == null) {
            return false;
        }
        AtomicInteger integer = this.transportRefCounter.get(clientTransport);
        if (integer == null) {
            needDestroy = true;
        } else {
            int currentCount = integer.decrementAndGet();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client transport {} of {} , current ref count is: {}", clientTransport, NetUtils.channelToString(clientTransport.localAddress(), clientTransport.remoteAddress()), currentCount);
            }
            if (currentCount <= 0) {
                String key = ReusableClientTransportHolder.getAddr(clientTransport.getConfig());
                this.clientTransportMap.remove(key);
                this.transportRefCounter.remove(clientTransport);
                needDestroy = true;
            } else {
                needDestroy = false;
            }
        }
        return needDestroy;
    }

    @Override
    public int size() {
        return this.clientTransportMap.size();
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, ClientTransport> entrySet : this.clientTransportMap.entrySet()) {
            ClientTransport clientTransport = entrySet.getValue();
            if (!clientTransport.isAvailable()) continue;
            clientTransport.destroy();
        }
        this.clientTransportMap.clear();
        this.transportRefCounter.clear();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }
}

