/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.rest;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.ReflectCache;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractProxyClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.rest.SofaResteasyClientBuilder;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

@Extension(value="rest")
public class RestClientTransport
extends AbstractProxyClientTransport {
    public RestClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
    }

    @Override
    protected Object buildProxy(ClientTransportConfig transportConfig) throws SofaRpcException {
        SofaResteasyClientBuilder builder = new SofaResteasyClientBuilder();
        ResteasyClient client = builder.registerProvider().logProviders().establishConnectionTimeout(transportConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).socketTimeout((long)transportConfig.getInvokeTimeout(), TimeUnit.MILLISECONDS).connectionPoolSize(transportConfig.getConnectionNum()).build();
        ProviderInfo provider = transportConfig.getProviderInfo();
        String url = "http://" + provider.getHost() + ":" + provider.getPort() + "/" + StringUtils.trimToEmpty(provider.getPath());
        ResteasyWebTarget target = client.target(url);
        return target.proxy(ClassUtils.forName(transportConfig.getConsumerConfig().getInterfaceId()));
    }

    @Override
    protected Method getMethod(SofaRequest request) throws SofaRpcException {
        return ReflectCache.getOrInitServiceMethod(request.getTargetServiceUniqueName(), request.getMethodName(), request.getMethodArgSigs(), true, request.getInterfaceName());
    }

    @Override
    protected void beforeSend(RpcInternalContext context, SofaRequest request) {
        super.beforeSend(context, request);
        if (EventBus.isEnable(ClientBeforeSendEvent.class)) {
            EventBus.post(new ClientBeforeSendEvent(request));
        }
    }
}

