/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.hystrix.SofaHystrixCommand;
import com.alipay.sofa.rpc.hystrix.SofaHystrixInvokable;
import com.alipay.sofa.rpc.hystrix.SofaHystrixObservableCommand;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;

@Extension(value="hystrix")
@AutoActive(consumerSide=true)
public class HystrixFilter
extends Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixFilter.class);

    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        AbstractInterfaceConfig config = invoker.getConfig();
        if (!this.isConsumerSide(config)) {
            if (LOGGER.isWarnEnabled(config.getAppName())) {
                LOGGER.warnWithApp(config.getAppName(), "HystrixFilter is not allowed on provider, interfaceId: {}", config.getInterfaceId());
            }
            return false;
        }
        if (!this.isHystrixEnabled(config)) {
            return false;
        }
        if (!this.isHystrixOnClasspath()) {
            if (LOGGER.isWarnEnabled(config.getAppName())) {
                LOGGER.warnWithApp(config.getAppName(), "HystrixFilter is disabled because 'com.netflix.hystrix:hystrix-core' does not exist on the classpath");
            }
            return false;
        }
        return true;
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        SofaHystrixInvokable command;
        if ("sync".equals(request.getInvokeType())) {
            command = new SofaHystrixCommand(invoker, request);
        } else if ("future".equals(request.getInvokeType())) {
            command = new SofaHystrixObservableCommand(invoker, request);
        } else {
            return invoker.invoke(request);
        }
        return command.invoke();
    }

    private boolean isConsumerSide(AbstractInterfaceConfig config) {
        return config instanceof ConsumerConfig;
    }

    private boolean isHystrixEnabled(AbstractInterfaceConfig config) {
        String consumerHystrixEnabled = config.getParameter("sofa.hystrix.enabled");
        if (StringUtils.isNotBlank(consumerHystrixEnabled)) {
            return Boolean.valueOf(consumerHystrixEnabled);
        }
        return RpcConfigs.getOrDefaultValue("sofa.hystrix.enabled", false);
    }

    private boolean isHystrixOnClasspath() {
        try {
            Class.forName("com.netflix.hystrix.HystrixCommand");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

