/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.internal;

import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.registry.consul.common.ConsulConstants;
import com.alipay.sofa.rpc.registry.consul.internal.TtlScheduler;
import com.alipay.sofa.rpc.registry.consul.model.ConsulEphemeralNode;
import com.alipay.sofa.rpc.registry.consul.model.ConsulRouterResp;
import com.alipay.sofa.rpc.registry.consul.model.ConsulService;
import com.alipay.sofa.rpc.registry.consul.model.ConsulServiceResp;
import com.alipay.sofa.rpc.registry.consul.model.ConsulSession;
import com.alipay.sofa.rpc.registry.consul.model.HeartbeatService;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.model.HealthService;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import com.ecwid.consul.v1.session.model.NewSession;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulManager.class);
    private final Object lock = new Object();
    private final ConsulClient client;
    private final TtlScheduler ttlScheduler;
    private final ScheduledExecutorService scheduleRegistry;

    public ConsulManager(String host, int port) {
        this.client = new ConsulClient(host, port);
        this.ttlScheduler = new TtlScheduler(this.client);
        this.scheduleRegistry = Executors.newScheduledThreadPool(1, new NamedThreadFactory("retryFailedTtl", true));
        this.scheduleRegistry.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ConsulManager.this.retryFailedTtl();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isInfoEnabled()) break block2;
                        LOGGER.info("retry registry znode failed", e);
                    }
                }
            }
        }, ConsulConstants.HEARTBEAT_CIRCLE, ConsulConstants.HEARTBEAT_CIRCLE, TimeUnit.MILLISECONDS);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ConsulEcwidClient init finish. client host:" + host + ", port:" + port);
        }
    }

    private void retryFailedTtl() {
        Set<HeartbeatService> failedService = this.ttlScheduler.getFailedService();
        Set<ConsulSession> failedSession = this.ttlScheduler.getFailedSession();
        if (failedSession.size() > 0 || failedService.size() > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("retry to registry failed service %d or failed session %d", failedService.size(), failedSession.size()));
            }
            for (HeartbeatService heartbeatService : failedService) {
                this.registerService(heartbeatService.getService());
            }
            HashSet allSuccess = Sets.newHashSet();
            for (ConsulSession consulSession : failedSession) {
                allSuccess.add(this.registerEphemralNode(consulSession.getEphemralNode()));
            }
            if (!allSuccess.contains(Boolean.FALSE)) {
                this.ttlScheduler.cleanFailedTtl();
            }
        }
    }

    public void registerService(ConsulService service) {
        NewService newService = service.getNewService();
        this.client.agentServiceRegister(newService);
        HeartbeatService heartbeatService = new HeartbeatService(service, newService);
        this.ttlScheduler.addHeartbeatServcie(heartbeatService);
    }

    public void unregisterService(ConsulService service) {
        NewService newService = service.getNewService();
        this.client.agentServiceDeregister(newService.getId());
        HeartbeatService heartbeatService = new HeartbeatService(service, newService);
        this.ttlScheduler.removeHeartbeatServcie(heartbeatService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean registerEphemralNode(ConsulEphemeralNode ephemralNode) {
        String sessionId = null;
        List sessions = (List)this.client.getSessionList(QueryParams.DEFAULT).getValue();
        if (sessions != null && !sessions.isEmpty()) {
            for (Object session : sessions) {
                if (!session.getName().equals(ephemralNode.getSessionName())) continue;
                sessionId = session.getId();
            }
        }
        if (sessionId == null) {
            Object session;
            NewSession newSession = ephemralNode.getNewSession();
            session = this.lock;
            synchronized (session) {
                sessionId = (String)this.client.sessionCreate(newSession, QueryParams.DEFAULT).getValue();
            }
        }
        ConsulSession session = new ConsulSession(sessionId, ephemralNode);
        this.ttlScheduler.addHeartbeatSession(session);
        PutParams kvPutParams = new PutParams();
        kvPutParams.setAcquireSession(sessionId);
        this.client.getKVValue(ephemralNode.getEphemralNodeKey());
        return (Boolean)this.client.setKVValue(ephemralNode.getEphemralNodeKey(), ephemralNode.getEphemralNodeValue(), kvPutParams).getValue();
    }

    public ConsulRouterResp lookupRouterMessage(String serviceName, long lastConsulIndex) {
        QueryParams queryParams = new QueryParams(ConsulConstants.CONSUL_BLOCK_TIME_SECONDS, lastConsulIndex);
        Response orgResponse = this.client.getKVValue(serviceName, queryParams);
        GetValue getValue = (GetValue)orgResponse.getValue();
        if (getValue != null && StringUtils.isNotBlank((CharSequence)getValue.getValue())) {
            String router = new String(Base64.decodeBase64((String)getValue.getValue()));
            ConsulRouterResp response = ConsulRouterResp.newResponse().withValue(router).withConsulIndex(orgResponse.getConsulIndex()).withConsulLastContact(orgResponse.getConsulLastContact()).withConsulKnowLeader(orgResponse.isConsulKnownLeader()).build();
            return response;
        }
        return null;
    }

    public ConsulServiceResp lookupHealthService(String serviceName, long lastConsulIndex) {
        QueryParams queryParams = new QueryParams(ConsulConstants.CONSUL_BLOCK_TIME_SECONDS, lastConsulIndex);
        Response orgResponse = this.client.getHealthServices(serviceName, true, queryParams);
        if (orgResponse != null && orgResponse.getValue() != null && !((List)orgResponse.getValue()).isEmpty()) {
            List healthServices = (List)orgResponse.getValue();
            ArrayList consulServices = Lists.newArrayList();
            for (HealthService orgService : healthServices) {
                HealthService.Service org = orgService.getService();
                ConsulService newService = ConsulService.newService().withAddress(org.getAddress()).withName(org.getService()).withId(org.getId()).withPort(org.getPort().toString()).withTags(org.getTags()).build();
                consulServices.add(newService);
            }
            if (!consulServices.isEmpty()) {
                ConsulServiceResp response = ConsulServiceResp.newResponse().withValue(consulServices).withConsulIndex(orgResponse.getConsulIndex()).withConsulLastContact(orgResponse.getConsulLastContact()).withConsulKnowLeader(orgResponse.isConsulKnownLeader()).build();
                return response;
            }
        }
        return null;
    }
}

