/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.nacos.NacosRegistryHelper;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NacosRegistryProviderObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRegistryProviderObserver.class);
    private ConcurrentMap<ConsumerConfig, List<ProviderInfoListener>> providerListenerMap = new ConcurrentHashMap<ConsumerConfig, List<ProviderInfoListener>>();

    void addProviderListener(ConsumerConfig consumerConfig, ProviderInfoListener listener) {
        if (listener != null) {
            RegistryUtils.initOrAddList(this.providerListenerMap, consumerConfig, listener);
        }
    }

    void removeProviderListener(ConsumerConfig consumerConfig) {
        this.providerListenerMap.remove(consumerConfig);
    }

    void updateProviders(ConsumerConfig config, List<Instance> instances) {
        List providerInfoListeners;
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive update provider: serviceName={}, size={}, data={}", config.getInterfaceId(), instances.size(), instances);
        }
        if (CommonUtils.isNotEmpty(providerInfoListeners = (List)this.providerListenerMap.get(config))) {
            List<ProviderInfo> providerInfos = NacosRegistryHelper.convertInstancesToProviders(instances);
            List<ProviderInfo> matchProviders = RegistryUtils.matchProviderInfos(config, providerInfos);
            for (ProviderInfoListener providerInfoListener : providerInfoListeners) {
                providerInfoListener.updateAllProviders(Collections.singletonList(new ProviderGroup().addAll(matchProviders)));
            }
        }
    }
}

