/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CancelOrderRequest
extends Request {
    @Query
    @NameInMap(value="OrderId")
    @Validation(required=true)
    private String orderId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;

    private CancelOrderRequest(Builder builder) {
        super((Request.Builder)builder);
        this.orderId = builder.orderId;
        this.ownerId = builder.ownerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CancelOrderRequest create() {
        return CancelOrderRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public static final class Builder
    extends Request.Builder<CancelOrderRequest, Builder> {
        private String orderId;
        private Long ownerId;

        private Builder() {
        }

        private Builder(CancelOrderRequest request) {
            super((Request)request);
            this.orderId = request.orderId;
            this.ownerId = request.ownerId;
        }

        public Builder orderId(String orderId) {
            this.putQueryParameter("OrderId", orderId);
            this.orderId = orderId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public CancelOrderRequest build() {
            return new CancelOrderRequest(this);
        }
    }
}

