/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ConfirmRelationRequest
extends Request {
    @Query
    @NameInMap(value="ChildUserId")
    @Validation
    private Long childUserId;
    @Query
    @NameInMap(value="ConfirmCode")
    @Validation(required=true)
    private String confirmCode;
    @Query
    @NameInMap(value="ParentUserId")
    @Validation
    private Long parentUserId;
    @Query
    @NameInMap(value="PermissionCodes")
    @Validation(required=true)
    private List<String> permissionCodes;
    @Query
    @NameInMap(value="RelationId")
    private Long relationId;
    @Query
    @NameInMap(value="RelationType")
    private String relationType;
    @Query
    @NameInMap(value="RequestId")
    @Validation(required=true)
    private String requestId;

    private ConfirmRelationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.childUserId = builder.childUserId;
        this.confirmCode = builder.confirmCode;
        this.parentUserId = builder.parentUserId;
        this.permissionCodes = builder.permissionCodes;
        this.relationId = builder.relationId;
        this.relationType = builder.relationType;
        this.requestId = builder.requestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConfirmRelationRequest create() {
        return ConfirmRelationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getChildUserId() {
        return this.childUserId;
    }

    public String getConfirmCode() {
        return this.confirmCode;
    }

    public Long getParentUserId() {
        return this.parentUserId;
    }

    public List<String> getPermissionCodes() {
        return this.permissionCodes;
    }

    public Long getRelationId() {
        return this.relationId;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public static final class Builder
    extends Request.Builder<ConfirmRelationRequest, Builder> {
        private Long childUserId;
        private String confirmCode;
        private Long parentUserId;
        private List<String> permissionCodes;
        private Long relationId;
        private String relationType;
        private String requestId;

        private Builder() {
        }

        private Builder(ConfirmRelationRequest request) {
            super((Request)request);
            this.childUserId = request.childUserId;
            this.confirmCode = request.confirmCode;
            this.parentUserId = request.parentUserId;
            this.permissionCodes = request.permissionCodes;
            this.relationId = request.relationId;
            this.relationType = request.relationType;
            this.requestId = request.requestId;
        }

        public Builder childUserId(Long childUserId) {
            this.putQueryParameter("ChildUserId", childUserId);
            this.childUserId = childUserId;
            return this;
        }

        public Builder confirmCode(String confirmCode) {
            this.putQueryParameter("ConfirmCode", confirmCode);
            this.confirmCode = confirmCode;
            return this;
        }

        public Builder parentUserId(Long parentUserId) {
            this.putQueryParameter("ParentUserId", parentUserId);
            this.parentUserId = parentUserId;
            return this;
        }

        public Builder permissionCodes(List<String> permissionCodes) {
            this.putQueryParameter("PermissionCodes", permissionCodes);
            this.permissionCodes = permissionCodes;
            return this;
        }

        public Builder relationId(Long relationId) {
            this.putQueryParameter("RelationId", relationId);
            this.relationId = relationId;
            return this;
        }

        public Builder relationType(String relationType) {
            this.putQueryParameter("RelationType", relationType);
            this.relationType = relationType;
            return this;
        }

        public Builder requestId(String requestId) {
            this.putQueryParameter("RequestId", requestId);
            this.requestId = requestId;
            return this;
        }

        public ConfirmRelationRequest build() {
            return new ConfirmRelationRequest(this);
        }
    }
}

