/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ConvertChargeTypeRequest
extends Request {
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="Period")
    private Integer period;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="SubscriptionType")
    @Validation(required=true)
    private String subscriptionType;

    private ConvertChargeTypeRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.ownerId = builder.ownerId;
        this.period = builder.period;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.subscriptionType = builder.subscriptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConvertChargeTypeRequest create() {
        return ConvertChargeTypeRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public static final class Builder
    extends Request.Builder<ConvertChargeTypeRequest, Builder> {
        private String instanceId;
        private Long ownerId;
        private Integer period;
        private String productCode;
        private String productType;
        private String subscriptionType;

        private Builder() {
        }

        private Builder(ConvertChargeTypeRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.ownerId = request.ownerId;
            this.period = request.period;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.subscriptionType = request.subscriptionType;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder period(Integer period) {
            this.putQueryParameter("Period", period);
            this.period = period;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.putQueryParameter("SubscriptionType", subscriptionType);
            this.subscriptionType = subscriptionType;
            return this;
        }

        public ConvertChargeTypeRequest build() {
            return new ConvertChargeTypeRequest(this);
        }
    }
}

