/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateInstanceRequest
extends Request {
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="Logistics")
    private String logistics;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="Parameter")
    private List<Parameter> parameter;
    @Query
    @NameInMap(value="Period")
    private Integer period;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="RenewPeriod")
    private Integer renewPeriod;
    @Query
    @NameInMap(value="RenewalStatus")
    private String renewalStatus;
    @Query
    @NameInMap(value="SubscriptionType")
    @Validation(required=true)
    private String subscriptionType;

    private CreateInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clientToken = builder.clientToken;
        this.logistics = builder.logistics;
        this.ownerId = builder.ownerId;
        this.parameter = builder.parameter;
        this.period = builder.period;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.renewPeriod = builder.renewPeriod;
        this.renewalStatus = builder.renewalStatus;
        this.subscriptionType = builder.subscriptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateInstanceRequest create() {
        return CreateInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getLogistics() {
        return this.logistics;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public Integer getRenewPeriod() {
        return this.renewPeriod;
    }

    public String getRenewalStatus() {
        return this.renewalStatus;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public static class Parameter
    extends TeaModel {
        @NameInMap(value="Code")
        @Validation(required=true)
        private String code;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private Parameter(Builder builder) {
            this.code = builder.code;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Parameter create() {
            return Parameter.builder().build();
        }

        public String getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String code;
            private String value;

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Parameter build() {
                return new Parameter(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateInstanceRequest, Builder> {
        private String clientToken;
        private String logistics;
        private Long ownerId;
        private List<Parameter> parameter;
        private Integer period;
        private String productCode;
        private String productType;
        private Integer renewPeriod;
        private String renewalStatus;
        private String subscriptionType;

        private Builder() {
        }

        private Builder(CreateInstanceRequest request) {
            super((Request)request);
            this.clientToken = request.clientToken;
            this.logistics = request.logistics;
            this.ownerId = request.ownerId;
            this.parameter = request.parameter;
            this.period = request.period;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.renewPeriod = request.renewPeriod;
            this.renewalStatus = request.renewalStatus;
            this.subscriptionType = request.subscriptionType;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder logistics(String logistics) {
            this.putQueryParameter("Logistics", logistics);
            this.logistics = logistics;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder parameter(List<Parameter> parameter) {
            this.putQueryParameter("Parameter", parameter);
            this.parameter = parameter;
            return this;
        }

        public Builder period(Integer period) {
            this.putQueryParameter("Period", period);
            this.period = period;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder renewPeriod(Integer renewPeriod) {
            this.putQueryParameter("RenewPeriod", renewPeriod);
            this.renewPeriod = renewPeriod;
            return this;
        }

        public Builder renewalStatus(String renewalStatus) {
            this.putQueryParameter("RenewalStatus", renewalStatus);
            this.renewalStatus = renewalStatus;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.putQueryParameter("SubscriptionType", subscriptionType);
            this.subscriptionType = subscriptionType;
            return this;
        }

        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }
    }
}

