/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateSavingsPlansInstanceRequest
extends Request {
    @Query
    @NameInMap(value="CommodityCode")
    @Validation(required=true)
    private String commodityCode;
    @Query
    @NameInMap(value="Duration")
    @Validation(required=true, minLength=1)
    private String duration;
    @Query
    @NameInMap(value="EffectiveDate")
    private String effectiveDate;
    @Query
    @NameInMap(value="ExtendMap")
    private Map<String, String> extendMap;
    @Query
    @NameInMap(value="PayMode")
    @Validation(required=true)
    private String payMode;
    @Query
    @NameInMap(value="PoolValue")
    @Validation(required=true)
    private String poolValue;
    @Query
    @NameInMap(value="PricingCycle")
    @Validation(required=true)
    private String pricingCycle;
    @Query
    @NameInMap(value="Region")
    private String region;
    @Query
    @NameInMap(value="SpecType")
    private String specType;
    @Query
    @NameInMap(value="Specification")
    private String specification;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private CreateSavingsPlansInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.commodityCode = builder.commodityCode;
        this.duration = builder.duration;
        this.effectiveDate = builder.effectiveDate;
        this.extendMap = builder.extendMap;
        this.payMode = builder.payMode;
        this.poolValue = builder.poolValue;
        this.pricingCycle = builder.pricingCycle;
        this.region = builder.region;
        this.specType = builder.specType;
        this.specification = builder.specification;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateSavingsPlansInstanceRequest create() {
        return CreateSavingsPlansInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public Map<String, String> getExtendMap() {
        return this.extendMap;
    }

    public String getPayMode() {
        return this.payMode;
    }

    public String getPoolValue() {
        return this.poolValue;
    }

    public String getPricingCycle() {
        return this.pricingCycle;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSpecType() {
        return this.specType;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<CreateSavingsPlansInstanceRequest, Builder> {
        private String commodityCode;
        private String duration;
        private String effectiveDate;
        private Map<String, String> extendMap;
        private String payMode;
        private String poolValue;
        private String pricingCycle;
        private String region;
        private String specType;
        private String specification;
        private String type;

        private Builder() {
        }

        private Builder(CreateSavingsPlansInstanceRequest request) {
            super((Request)request);
            this.commodityCode = request.commodityCode;
            this.duration = request.duration;
            this.effectiveDate = request.effectiveDate;
            this.extendMap = request.extendMap;
            this.payMode = request.payMode;
            this.poolValue = request.poolValue;
            this.pricingCycle = request.pricingCycle;
            this.region = request.region;
            this.specType = request.specType;
            this.specification = request.specification;
            this.type = request.type;
        }

        public Builder commodityCode(String commodityCode) {
            this.putQueryParameter("CommodityCode", commodityCode);
            this.commodityCode = commodityCode;
            return this;
        }

        public Builder duration(String duration) {
            this.putQueryParameter("Duration", duration);
            this.duration = duration;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.putQueryParameter("EffectiveDate", effectiveDate);
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder extendMap(Map<String, String> extendMap) {
            String extendMapShrink = this.shrink(extendMap, "ExtendMap", "json");
            this.putQueryParameter("ExtendMap", extendMapShrink);
            this.extendMap = extendMap;
            return this;
        }

        public Builder payMode(String payMode) {
            this.putQueryParameter("PayMode", payMode);
            this.payMode = payMode;
            return this;
        }

        public Builder poolValue(String poolValue) {
            this.putQueryParameter("PoolValue", poolValue);
            this.poolValue = poolValue;
            return this;
        }

        public Builder pricingCycle(String pricingCycle) {
            this.putQueryParameter("PricingCycle", pricingCycle);
            this.pricingCycle = pricingCycle;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder specType(String specType) {
            this.putQueryParameter("SpecType", specType);
            this.specType = specType;
            return this;
        }

        public Builder specification(String specification) {
            this.putQueryParameter("Specification", specification);
            this.specification = specification;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public CreateSavingsPlansInstanceRequest build() {
            return new CreateSavingsPlansInstanceRequest(this);
        }
    }
}

