/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class GetPayAsYouGoPriceRequest
extends Request {
    @Query
    @NameInMap(value="ModuleList")
    @Validation(required=true)
    private List<ModuleList> moduleList;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="Region")
    private String region;
    @Query
    @NameInMap(value="SubscriptionType")
    @Validation(required=true)
    private String subscriptionType;

    private GetPayAsYouGoPriceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.moduleList = builder.moduleList;
        this.ownerId = builder.ownerId;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.region = builder.region;
        this.subscriptionType = builder.subscriptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetPayAsYouGoPriceRequest create() {
        return GetPayAsYouGoPriceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<ModuleList> getModuleList() {
        return this.moduleList;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public static class ModuleList
    extends TeaModel {
        @NameInMap(value="Config")
        @Validation(required=true)
        private String config;
        @NameInMap(value="ModuleCode")
        @Validation(required=true)
        private String moduleCode;
        @NameInMap(value="PriceType")
        @Validation(required=true)
        private String priceType;

        private ModuleList(Builder builder) {
            this.config = builder.config;
            this.moduleCode = builder.moduleCode;
            this.priceType = builder.priceType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ModuleList create() {
            return ModuleList.builder().build();
        }

        public String getConfig() {
            return this.config;
        }

        public String getModuleCode() {
            return this.moduleCode;
        }

        public String getPriceType() {
            return this.priceType;
        }

        public static final class Builder {
            private String config;
            private String moduleCode;
            private String priceType;

            public Builder config(String config) {
                this.config = config;
                return this;
            }

            public Builder moduleCode(String moduleCode) {
                this.moduleCode = moduleCode;
                return this;
            }

            public Builder priceType(String priceType) {
                this.priceType = priceType;
                return this;
            }

            public ModuleList build() {
                return new ModuleList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<GetPayAsYouGoPriceRequest, Builder> {
        private List<ModuleList> moduleList;
        private Long ownerId;
        private String productCode;
        private String productType;
        private String region;
        private String subscriptionType;

        private Builder() {
        }

        private Builder(GetPayAsYouGoPriceRequest request) {
            super((Request)request);
            this.moduleList = request.moduleList;
            this.ownerId = request.ownerId;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.region = request.region;
            this.subscriptionType = request.subscriptionType;
        }

        public Builder moduleList(List<ModuleList> moduleList) {
            this.putQueryParameter("ModuleList", moduleList);
            this.moduleList = moduleList;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.putQueryParameter("SubscriptionType", subscriptionType);
            this.subscriptionType = subscriptionType;
            return this;
        }

        public GetPayAsYouGoPriceRequest build() {
            return new GetPayAsYouGoPriceRequest(this);
        }
    }
}

