/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.bssopenapi20171214.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class GetSubscriptionPriceRequest
extends Request {
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;
    @Query
    @NameInMap(value="ModuleList")
    @Validation(required=true)
    private List<ModuleList> moduleList;
    @Query
    @NameInMap(value="OrderType")
    @Validation(required=true)
    private String orderType;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ProductCode")
    @Validation(required=true)
    private String productCode;
    @Query
    @NameInMap(value="ProductType")
    private String productType;
    @Query
    @NameInMap(value="Quantity")
    private Integer quantity;
    @Query
    @NameInMap(value="Region")
    private String region;
    @Query
    @NameInMap(value="ServicePeriodQuantity")
    private Integer servicePeriodQuantity;
    @Query
    @NameInMap(value="ServicePeriodUnit")
    private String servicePeriodUnit;
    @Query
    @NameInMap(value="SubscriptionType")
    @Validation(required=true)
    private String subscriptionType;

    private GetSubscriptionPriceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.moduleList = builder.moduleList;
        this.orderType = builder.orderType;
        this.ownerId = builder.ownerId;
        this.productCode = builder.productCode;
        this.productType = builder.productType;
        this.quantity = builder.quantity;
        this.region = builder.region;
        this.servicePeriodQuantity = builder.servicePeriodQuantity;
        this.servicePeriodUnit = builder.servicePeriodUnit;
        this.subscriptionType = builder.subscriptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetSubscriptionPriceRequest create() {
        return GetSubscriptionPriceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<ModuleList> getModuleList() {
        return this.moduleList;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getRegion() {
        return this.region;
    }

    public Integer getServicePeriodQuantity() {
        return this.servicePeriodQuantity;
    }

    public String getServicePeriodUnit() {
        return this.servicePeriodUnit;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public static class ModuleList
    extends TeaModel {
        @NameInMap(value="Config")
        @Validation(required=true)
        private String config;
        @NameInMap(value="ModuleCode")
        @Validation(required=true)
        private String moduleCode;
        @NameInMap(value="ModuleStatus")
        private Integer moduleStatus;
        @NameInMap(value="Tag")
        private String tag;

        private ModuleList(Builder builder) {
            this.config = builder.config;
            this.moduleCode = builder.moduleCode;
            this.moduleStatus = builder.moduleStatus;
            this.tag = builder.tag;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ModuleList create() {
            return ModuleList.builder().build();
        }

        public String getConfig() {
            return this.config;
        }

        public String getModuleCode() {
            return this.moduleCode;
        }

        public Integer getModuleStatus() {
            return this.moduleStatus;
        }

        public String getTag() {
            return this.tag;
        }

        public static final class Builder {
            private String config;
            private String moduleCode;
            private Integer moduleStatus;
            private String tag;

            public Builder config(String config) {
                this.config = config;
                return this;
            }

            public Builder moduleCode(String moduleCode) {
                this.moduleCode = moduleCode;
                return this;
            }

            public Builder moduleStatus(Integer moduleStatus) {
                this.moduleStatus = moduleStatus;
                return this;
            }

            public Builder tag(String tag) {
                this.tag = tag;
                return this;
            }

            public ModuleList build() {
                return new ModuleList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<GetSubscriptionPriceRequest, Builder> {
        private String instanceId;
        private List<ModuleList> moduleList;
        private String orderType;
        private Long ownerId;
        private String productCode;
        private String productType;
        private Integer quantity;
        private String region;
        private Integer servicePeriodQuantity;
        private String servicePeriodUnit;
        private String subscriptionType;

        private Builder() {
        }

        private Builder(GetSubscriptionPriceRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.moduleList = request.moduleList;
            this.orderType = request.orderType;
            this.ownerId = request.ownerId;
            this.productCode = request.productCode;
            this.productType = request.productType;
            this.quantity = request.quantity;
            this.region = request.region;
            this.servicePeriodQuantity = request.servicePeriodQuantity;
            this.servicePeriodUnit = request.servicePeriodUnit;
            this.subscriptionType = request.subscriptionType;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder moduleList(List<ModuleList> moduleList) {
            this.putQueryParameter("ModuleList", moduleList);
            this.moduleList = moduleList;
            return this;
        }

        public Builder orderType(String orderType) {
            this.putQueryParameter("OrderType", orderType);
            this.orderType = orderType;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder productCode(String productCode) {
            this.putQueryParameter("ProductCode", productCode);
            this.productCode = productCode;
            return this;
        }

        public Builder productType(String productType) {
            this.putQueryParameter("ProductType", productType);
            this.productType = productType;
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.putQueryParameter("Quantity", quantity);
            this.quantity = quantity;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder servicePeriodQuantity(Integer servicePeriodQuantity) {
            this.putQueryParameter("ServicePeriodQuantity", servicePeriodQuantity);
            this.servicePeriodQuantity = servicePeriodQuantity;
            return this;
        }

        public Builder servicePeriodUnit(String servicePeriodUnit) {
            this.putQueryParameter("ServicePeriodUnit", servicePeriodUnit);
            this.servicePeriodUnit = servicePeriodUnit;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.putQueryParameter("SubscriptionType", subscriptionType);
            this.subscriptionType = subscriptionType;
            return this;
        }

        public GetSubscriptionPriceRequest build() {
            return new GetSubscriptionPriceRequest(this);
        }
    }
}

